/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.etee.impl;

import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import java.security.KeyStore;


/**
 * Integration test for {@link ConnectorOCSPRevocationStatusChecker}.
 *
 * @author EHP
 */
public class ConnectorOCSPRevocationStatusCheckerUserIntegrationTest {

	@ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession()
            .build();
	
    @Before
    public void before() throws Exception {
        AssumeTools.isEIDEnabled();
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        store.setCertificateEntry("ca", BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[1]);
        store.setCertificateEntry("ca2", BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS).getCertificateChain()[2]);
    }


    @After
    public void after() throws Exception {
        KeyStore store = (KeyStore) CryptoFactory.getOCSPOptions().get(OCSPOption.TRUST_STORE);
        store.deleteEntry("ca");
        store.deleteEntry("ca2");
    }


    @Test
    public void testWithEid() throws Exception {
        ConnectorOCSPRevocationStatusChecker checker = new ConnectorOCSPRevocationStatusChecker();
        boolean isRevoked = checker.isRevoked(BeIDCredential.getInstance("test", BeIDCredential.EID_AUTH_ALIAS)
                .getCertificate());
        Assert.assertFalse("Certificate is revoked.", isRevoked);
    }
}
