/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.curl;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.netty.codec.mappers.MockServerHttpRequestToFullHttpRequest;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;

public class HttpRequestToCurlSerializer {
    public String toCurl(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress) {
        StringBuilder curlString = new StringBuilder();
        if (httpRequest != null) {
            if (!Strings.isNullOrEmpty((String)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString())) || remoteAddress != null) {
                boolean isSsl = httpRequest.isSecure() != null && httpRequest.isSecure() != false;
                curlString.append("curl -v");
                curlString.append(" ");
                curlString.append("'");
                curlString.append(isSsl ? "https" : "http");
                curlString.append("://");
                curlString.append(this.getHostAndPort(httpRequest, remoteAddress));
                curlString.append(this.getUri(httpRequest));
                curlString.append("'");
                if (!this.hasDefaultMethod(httpRequest)) {
                    curlString.append(" -X ").append(httpRequest.getMethod().getValue());
                }
                for (Header header : httpRequest.getHeaders()) {
                    for (NottableString headerValue : header.getValues()) {
                        curlString.append(" -H '").append(header.getName().getValue()).append(": ").append(headerValue.getValue()).append("'");
                        if (!header.getName().getValue().toLowerCase().contains("Accept-Encoding".toLowerCase()) || !headerValue.getValue().toLowerCase().contains("gzip") && !headerValue.getValue().toLowerCase().contains("deflate") && !headerValue.getValue().toLowerCase().contains("sdch")) continue;
                        curlString.append(" ");
                        curlString.append("--compress");
                    }
                }
                curlString.append(this.getCookieHeader(httpRequest));
            } else {
                curlString.append("no host header or remote address specified");
            }
        } else {
            curlString.append("null HttpRequest");
        }
        return curlString.toString();
    }

    private boolean hasDefaultMethod(HttpRequest httpRequest) {
        return Strings.isNullOrEmpty((String)httpRequest.getMethod().getValue()) || httpRequest.getMethod().getValue().equalsIgnoreCase("GET");
    }

    private String getUri(HttpRequest outboundHttpRequest) {
        String uri = new MockServerHttpRequestToFullHttpRequest().getURI(outboundHttpRequest);
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "/";
        } else if (!StringUtils.startsWith((CharSequence)uri, (CharSequence)"/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    private String getHostAndPort(HttpRequest httpRequest, InetSocketAddress remoteAddress) {
        String host = httpRequest.getFirstHeader("Host");
        if (Strings.isNullOrEmpty((String)host)) {
            host = remoteAddress.getHostName() + ":" + remoteAddress.getPort();
        }
        return host;
    }

    private String getCookieHeader(HttpRequest httpRequest) {
        ArrayList<DefaultCookie> cookies = new ArrayList<DefaultCookie>();
        for (Cookie cookie : httpRequest.getCookies()) {
            cookies.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
        }
        if (cookies.size() > 0) {
            return " -H '" + HttpHeaderNames.COOKIE + ": " + ClientCookieEncoder.LAX.encode(cookies) + "'";
        }
        return "";
    }
}

