/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.signature.impl.AbstractSignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.SignatureUtils;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CmsSignatureBuilder
extends AbstractSignatureBuilder
implements SignatureBuilder {
    private static final String MSG_VERIFY_FAILED = "Unable to verify signature";
    private static final Logger LOG = LoggerFactory.getLogger(CmsSignatureBuilder.class);
    private static JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
    private static JcaSimpleSignerInfoVerifierBuilder verifierBuilder = new JcaSimpleSignerInfoVerifierBuilder();
    private AdvancedElectronicSignatureEnumeration aes;

    public CmsSignatureBuilder(AdvancedElectronicSignatureEnumeration aes) {
        this.aes = aes;
    }

    @Override
    public AdvancedElectronicSignatureEnumeration getSupportedAES() {
        return this.aes;
    }

    @Override
    public SignatureVerificationResult verify(byte[] content, byte[] signature, Map<String, Object> options) throws TechnicalConnectorException {
        SignatureVerificationResult result = new SignatureVerificationResult();
        try {
            byte[] signedData;
            CMSSignedData signedContent = new CMSSignedData(signature);
            if (signedContent.getSignedContent() == null) {
                LOG.info("Signature has no ecapsulated signature. Adding content.");
                signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(content), signature).getEncoded();
            } else {
                signedData = ArrayUtils.clone((byte[])signature);
            }
            return this.verify(signedData, options);
        }
        catch (CMSException e) {
            LOG.error(MSG_VERIFY_FAILED, (Throwable)e);
            result.addError(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
        }
        catch (IOException e) {
            LOG.error(MSG_VERIFY_FAILED, (Throwable)e);
            result.addError(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
        }
        return result;
    }

    @Override
    public SignatureVerificationResult verify(Document signedContent, Element sigElement, Map<String, Object> options) throws TechnicalConnectorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SignatureVerificationResult verify(byte[] signedByteArray, Map<String, Object> options) throws TechnicalConnectorException {
        SignatureVerificationResult result = new SignatureVerificationResult();
        try {
            CMSSignedData signedData = new CMSSignedData(signedByteArray);
            this.extractChain(result, signedData);
            this.validateChain(result, options);
            for (SignerInformation signer : signedData.getSignerInfos()) {
                if (signer.verify(verifierBuilder.build(result.getSigningCert().getPublicKey()))) continue;
                result.addError(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
            }
        }
        catch (Exception e) {
            LOG.error(MSG_VERIFY_FAILED, (Throwable)e);
            result.addError(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
        }
        return result;
    }

    @Override
    public byte[] sign(Credential signatureCredential, byte[] byteArrayToSign) throws TechnicalConnectorException {
        return this.sign(signatureCredential, byteArrayToSign, null);
    }

    @Override
    public byte[] sign(Credential signatureCredential, byte[] byteToSign, Map<String, Object> options) throws TechnicalConnectorException {
        byte[] contentToSign = ArrayUtils.clone((byte[])byteToSign);
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        if (options != null) {
            optionMap.putAll(options);
        }
        this.validateInput(signatureCredential, contentToSign);
        try {
            CMSProcessableByteArray content = new CMSProcessableByteArray(contentToSign);
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            String signatureAlgorithm = SignatureUtils.getOption("signatureAlgorithm", optionMap, this.determineDefaultAlgo(signatureCredential));
            JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build());
            ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(signatureCredential.getPrivateKey());
            CMSAttributeTableGenerator cmsAttributeTableGenerator = (CMSAttributeTableGenerator)SignatureUtils.getOption("signedAttributeGenerator", optionMap, new DefaultSignedAttributeTableGenerator());
            signerInfoGeneratorBuilder.setSignedAttributeGenerator(cmsAttributeTableGenerator);
            generator.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(contentSigner, signatureCredential.getCertificate()));
            Certificate[] certificateChain = signatureCredential.getCertificateChain();
            if (certificateChain != null && certificateChain.length > 0) {
                generator.addCertificates((Store)new JcaCertStore(Arrays.asList(certificateChain)));
            }
            boolean encapsulate = SignatureUtils.getOption("encapsulate", optionMap, Boolean.FALSE);
            return generator.generate((CMSTypedData)content, encapsulate).getEncoded();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_SIGNATURE, (Throwable)e, new Object[]{e.getClass().getSimpleName() + " : " + e.getMessage()});
        }
    }

    @Override
    protected String determineDefaultAlgo(Credential signatureCredential) throws TechnicalConnectorException {
        String keyType;
        switch (keyType = signatureCredential.getPrivateKey().getAlgorithm()) {
            case "RSA": {
                return "SHA256withRSA";
            }
            case "EC": {
                return "SHA256withECDSA";
            }
        }
        throw new IllegalArgumentException("Unsupported credential of type " + keyType);
    }

    private void extractChain(SignatureVerificationResult result, CMSSignedData signedData) throws CertificateException {
        Store certs = signedData.getCertificates();
        Collection certCollection = certs.getMatches((Selector)new X509CertifcateSelector());
        Iterator iterator = certCollection.iterator();
        while (iterator.hasNext()) {
            result.getCertChain().add(converter.getCertificate((X509CertificateHolder)iterator.next()));
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static class X509CertifcateSelector
    implements Selector<X509CertificateHolder> {
        private X509CertifcateSelector() {
        }

        public boolean match(X509CertificateHolder cert) {
            return true;
        }

        public Object clone() {
            return new X509CertifcateSelector();
        }
    }
}

