/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import java.util.Date;

public final class TimeFrameValidator {
    private final long acceptedClockSkew;

    private TimeFrameValidator(long acceptedClockSkew) {
        this.acceptedClockSkew = acceptedClockSkew;
    }

    public static TimeFrameValidator create(long acceptedClockSkew) {
        return new TimeFrameValidator(acceptedClockSkew);
    }

    public boolean validate(Date minDate, Date dateInBetween, Date maxDate) {
        Date dateToTest = dateInBetween != null ? dateInBetween : new Date();
        return !(maxDate != null && !this.isValid(dateToTest, maxDate) || minDate != null && !this.isValid(minDate, dateToTest));
    }

    private boolean isValid(Date first, Date second) {
        long diff = second.getTime() - first.getTime();
        return diff > 0L || Math.abs(diff) < this.acceptedClockSkew;
    }
}

