/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.shutdown;

import be.ehealth.technicalconnector.shutdown.ShutdownHook;
import be.ehealth.technicalconnector.shutdown.ShutdownRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DeleteFileOnExitShutdownHook
implements ShutdownHook {
    public static final String SYS_PROP_DELETE_ON_EXIT = "be.ehealth.technicalconnector.shutdown.deletefileonexit.activated";
    private DeleteOnExit hook;

    public static void execute() {
        DeleteFileOnExitShutdownHookEnum.INSTANCE.getShutdownHook().shutdown();
    }

    public static void deleteOnExit(File file) {
        DeleteFileOnExitShutdownHookEnum.INSTANCE.getShutdownHook().hook.deleteOnExit(file);
    }

    private DeleteFileOnExitShutdownHook(DeleteOnExit hook) {
        this.hook = hook;
    }

    @Override
    public void shutdown() {
        this.hook.shutdown();
    }

    private static class CustomDeleteOnExit
    implements DeleteOnExit {
        private List<File> deleteOnExitFiles = new ArrayList<File>();

        private CustomDeleteOnExit() {
        }

        @Override
        public void deleteOnExit(File file) {
            this.deleteOnExitFiles.add(file);
        }

        @Override
        public void shutdown() {
            for (File file : this.deleteOnExitFiles) {
                file.delete();
            }
        }
    }

    private static class JVMDeleteOnExit
    implements DeleteOnExit {
        private JVMDeleteOnExit() {
        }

        @Override
        public void deleteOnExit(File file) {
            file.deleteOnExit();
        }

        @Override
        public void shutdown() {
        }
    }

    private static interface DeleteOnExit {
        public void deleteOnExit(File var1);

        public void shutdown();
    }

    private static enum DeleteFileOnExitShutdownHookEnum {
        INSTANCE;

        private DeleteFileOnExitShutdownHook shutdownHook = "true".equals(System.getProperty("be.ehealth.technicalconnector.shutdown.deletefileonexit.activated", "false")) ? new DeleteFileOnExitShutdownHook(new CustomDeleteOnExit()) : new DeleteFileOnExitShutdownHook(new JVMDeleteOnExit());

        private DeleteFileOnExitShutdownHookEnum() {
            ShutdownRegistry.register(this.shutdownHook);
        }

        public DeleteFileOnExitShutdownHook getShutdownHook() {
            return this.shutdownHook;
        }
    }
}

