/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.DataSealChecker;
import be.fgov.ehealth.etee.crypto.decrypt.DataSealCheckerImpl;
import be.fgov.ehealth.etee.crypto.decrypt.DataSealSteps;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.utils.SecurityConfiguration;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public final class DataSealCheckerBuilder {
    private DataSealCheckerBuilder() {
    }

    public static OCSPPolicyStep newBuilder() {
        SecurityConfiguration.configure();
        return new Steps();
    }

    private static class Steps
    extends DataSealSteps
    implements OCSPPolicyStep,
    SigningPolicyStep,
    BuildStep {
        private Steps() {
        }

        @Override
        public DataSealChecker build() {
            super.processConfig();
            return new DataSealCheckerImpl(this.getOuterSignedDataVerifier(), this.getSignerInfoAttributesReceiver(), this.getOcspOptionsToUse().getBoolean(OCSPOption.INJECT_RESPONSE), this.getTimeStampTrustService());
        }

        @Override
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy policy) {
            return this.addOCSPPolicy(policy, new HashMap<OCSPOption, Object>());
        }

        @Override
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy policy, Map<OCSPOption, Object> ocspOptions) {
            this.addConfig(policy, ocspOptions);
            return this;
        }

        @Override
        public BuildStep addSigningPolicy(KeyStore keyStore, SigningPolicy ... signingPolicies) {
            return this.addSigningPolicy(keyStore, new HashMap<SigningOption, Object>(), signingPolicies);
        }

        @Override
        public BuildStep addSigningPolicy(KeyStore keyStore, Map<SigningOption, Object> signingOptions, SigningPolicy ... signingPolicies) {
            this.addConfig(keyStore, signingOptions, signingPolicies);
            return this;
        }
    }

    public static interface BuildStep {
        public DataSealChecker build();
    }

    public static interface SigningPolicyStep {
        public BuildStep addSigningPolicy(KeyStore var1, SigningPolicy ... var2);

        public BuildStep addSigningPolicy(KeyStore var1, Map<SigningOption, Object> var2, SigningPolicy ... var3);
    }

    public static interface OCSPPolicyStep
    extends SigningPolicyStep {
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy var1);

        public SigningPolicyStep addOCSPPolicy(OCSPPolicy var1, Map<OCSPOption, Object> var2);
    }
}

