/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client;

import be.fedict.commons.eid.client.event.CardEventsListener;
import be.fedict.commons.eid.client.event.CardTerminalEventsListener;
import be.fedict.commons.eid.client.impl.CardTerminalsProxy;
import be.fedict.commons.eid.client.impl.LibJ2PCSCGNULinuxFix;
import be.fedict.commons.eid.client.impl.VoidLogger;
import be.fedict.commons.eid.client.spi.Logger;
import java.util.HashSet;
import java.util.Set;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;

public class CardAndTerminalManager
implements Runnable {
    private static final int DEFAULT_DELAY = 250;
    private boolean running;
    private boolean subSystemInitialized;
    private boolean autoconnect;
    private Thread worker;
    private Set<CardTerminal> terminalsPresent;
    private Set<CardTerminal> terminalsWithCards;
    private CardTerminals cardTerminals;
    private final Set<String> terminalsToIgnoreCardEventsFor;
    private final Set<CardTerminalEventsListener> cardTerminalEventsListeners;
    private final Set<CardEventsListener> cardEventsListeners;
    private int delay;
    private Logger logger;
    private PROTOCOL protocol;

    public CardAndTerminalManager() {
        this(new VoidLogger());
    }

    public CardAndTerminalManager(Logger logger) {
        this(logger, null);
    }

    public CardAndTerminalManager(CardTerminals cardTerminals) {
        this(new VoidLogger(), cardTerminals);
    }

    public CardAndTerminalManager(Logger logger, CardTerminals cardTerminals) {
        LibJ2PCSCGNULinuxFix.fixNativeLibrary(logger);
        this.cardTerminalEventsListeners = new HashSet<CardTerminalEventsListener>();
        this.cardEventsListeners = new HashSet<CardEventsListener>();
        this.terminalsToIgnoreCardEventsFor = new HashSet<String>();
        this.delay = 250;
        this.logger = logger;
        this.running = false;
        this.subSystemInitialized = false;
        this.autoconnect = true;
        this.protocol = PROTOCOL.ANY;
        this.cardTerminals = cardTerminals == null ? CardTerminalsProxy.getCardTerminals(logger) : cardTerminals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardAndTerminalManager addCardTerminalListener(CardTerminalEventsListener listener) {
        Set<CardTerminalEventsListener> set = this.cardTerminalEventsListeners;
        synchronized (set) {
            this.cardTerminalEventsListeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardAndTerminalManager addCardListener(CardEventsListener listener) {
        Set<CardEventsListener> set = this.cardEventsListeners;
        synchronized (set) {
            this.cardEventsListeners.add(listener);
        }
        return this;
    }

    public CardAndTerminalManager start() {
        this.logger.debug("CardAndTerminalManager worker thread start requested.");
        if (null != this.worker) {
            throw new IllegalStateException("already started");
        }
        this.worker = new Thread((Runnable)this, "CardAndTerminalManager");
        this.worker.setDaemon(true);
        this.worker.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardAndTerminalManager removeCardTerminalListener(CardTerminalEventsListener listener) {
        Set<CardTerminalEventsListener> set = this.cardTerminalEventsListeners;
        synchronized (set) {
            this.cardTerminalEventsListeners.remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardAndTerminalManager removeCardListener(CardEventsListener listener) {
        Set<CardEventsListener> set = this.cardEventsListeners;
        synchronized (set) {
            this.cardEventsListeners.remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardAndTerminalManager ignoreCardEventsFor(String terminalName) {
        Set<String> set = this.terminalsToIgnoreCardEventsFor;
        synchronized (set) {
            this.terminalsToIgnoreCardEventsFor.add(terminalName);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardAndTerminalManager acceptCardEventsFor(String terminalName) {
        Set<String> set = this.terminalsToIgnoreCardEventsFor;
        synchronized (set) {
            this.terminalsToIgnoreCardEventsFor.remove(terminalName);
        }
        return this;
    }

    public CardAndTerminalManager stop() throws InterruptedException {
        this.logger.debug("CardAndTerminalManager worker thread stop requested.");
        this.running = false;
        this.worker.interrupt();
        this.worker.join();
        this.worker = null;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    public CardAndTerminalManager setDelay(int newDelay) {
        this.delay = newDelay;
        return this;
    }

    public boolean isAutoconnect() {
        return this.autoconnect;
    }

    public CardAndTerminalManager setAutoconnect(boolean newAutoConnect) {
        this.autoconnect = newAutoConnect;
        return this;
    }

    public PROTOCOL getProtocol() {
        return this.protocol;
    }

    public CardAndTerminalManager setProtocol(PROTOCOL newProtocol) {
        this.protocol = newProtocol;
        return this;
    }

    @Override
    public void run() {
        block3: {
            this.running = true;
            this.logger.debug("CardAndTerminalManager worker thread started.");
            try {
                this.handlePCSCEvents();
                this.listenersInitialized();
                while (this.running) {
                    this.handlePCSCEvents();
                }
            }
            catch (InterruptedException iex) {
                if (!this.running) break block3;
                this.logger.error("CardAndTerminalManager worker thread unexpectedly interrupted: " + iex.getLocalizedMessage());
            }
        }
        this.logger.debug("CardAndTerminalManager worker thread ended.");
    }

    private void handlePCSCEvents() throws InterruptedException {
        if (!this.subSystemInitialized) {
            this.logger.debug("subsystem not initialized");
            try {
                if (this.terminalsPresent == null || this.terminalsWithCards == null) {
                    this.terminalsPresent = new HashSet<CardTerminal>(this.cardTerminals.list(CardTerminals.State.ALL));
                    this.terminalsWithCards = this.terminalsWithCardsIn(this.terminalsPresent);
                }
                this.listenersTerminalsAttachedCardsInserted(this.terminalsPresent, this.terminalsWithCards);
                this.subSystemInitialized = true;
            }
            catch (CardException cex) {
                this.logCardException(cex, "Cannot enumerate card terminals [1] (No Card Readers Connected?)");
                this.clear();
                this.sleepForDelay();
                return;
            }
        }
        try {
            this.cardTerminals.waitForChange(this.delay);
        }
        catch (CardException cex) {
            this.logCardException(cex, "Cannot wait for card terminal events [2] (No Card Readers Connected?)");
            this.clear();
            this.sleepForDelay();
            return;
        }
        catch (IllegalStateException ise) {
            this.logger.debug("Cannot wait for card terminal changes (no PCSC subsystem?): " + ise.getLocalizedMessage());
            this.clear();
            this.sleepForDelay();
            return;
        }
        try {
            HashSet<CardTerminal> currentTerminals = new HashSet<CardTerminal>(this.cardTerminals.list(CardTerminals.State.ALL));
            Set<CardTerminal> currentTerminalsWithCards = this.terminalsWithCardsIn(currentTerminals);
            HashSet<CardTerminal> terminalsAttached = new HashSet<CardTerminal>(currentTerminals);
            terminalsAttached.removeAll(this.terminalsPresent);
            HashSet<CardTerminal> terminalsWithCardsInserted = new HashSet<CardTerminal>(currentTerminalsWithCards);
            terminalsWithCardsInserted.removeAll(this.terminalsWithCards);
            HashSet<CardTerminal> terminalsWithCardsRemoved = new HashSet<CardTerminal>(this.terminalsWithCards);
            terminalsWithCardsRemoved.removeAll(currentTerminalsWithCards);
            HashSet<CardTerminal> terminalsDetached = new HashSet<CardTerminal>(this.terminalsPresent);
            terminalsDetached.removeAll(currentTerminals);
            this.terminalsPresent = currentTerminals;
            this.terminalsWithCards = currentTerminalsWithCards;
            this.listenersUpdateInSequence(terminalsAttached, terminalsWithCardsInserted, terminalsWithCardsRemoved, terminalsDetached);
        }
        catch (CardException cex) {
            this.logCardException(cex, "Cannot wait for card terminal changes (no PCSC subsystem?)");
            this.clear();
            this.sleepForDelay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areCardEventsIgnoredFor(CardTerminal cardTerminal) {
        Set<String> set = this.terminalsToIgnoreCardEventsFor;
        synchronized (set) {
            for (String prefixToMatch : this.terminalsToIgnoreCardEventsFor) {
                if (!cardTerminal.getName().startsWith(prefixToMatch)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<CardTerminal> terminalsWithCardsIn(Set<CardTerminal> terminals) {
        HashSet<CardTerminal> terminalsWithCards = new HashSet<CardTerminal>();
        Set<String> set = this.terminalsToIgnoreCardEventsFor;
        synchronized (set) {
            for (CardTerminal terminal : terminals) {
                try {
                    if (!terminal.isCardPresent() || this.areCardEventsIgnoredFor(terminal)) continue;
                    terminalsWithCards.add(terminal);
                }
                catch (CardException cex) {
                    this.logger.error("Problem determining card presence in terminal [" + terminal.getName() + "]", cex);
                }
            }
        }
        return terminalsWithCards;
    }

    private void clear() {
        if (this.subSystemInitialized) {
            this.listenersCardsRemovedTerminalsDetached(this.terminalsWithCards, this.terminalsPresent);
        }
        this.terminalsPresent = null;
        this.terminalsWithCards = null;
        this.subSystemInitialized = false;
        this.logger.debug("cleared");
    }

    private void listenersTerminalsAttachedCardsInserted(Set<CardTerminal> attached, Set<CardTerminal> inserted) throws CardException {
        this.listenersTerminalsAttached(attached);
        this.listenersTerminalsWithCardsInserted(inserted);
    }

    private void listenersCardsRemovedTerminalsDetached(Set<CardTerminal> removed, Set<CardTerminal> detached) {
        this.listenersTerminalsWithCardsRemoved(removed);
        this.listenersTerminalsDetached(detached);
    }

    private void listenersUpdateInSequence(Set<CardTerminal> attached, Set<CardTerminal> inserted, Set<CardTerminal> removed, Set<CardTerminal> detached) throws CardException {
        this.listenersTerminalsAttached(attached);
        this.listenersTerminalsWithCardsInserted(inserted);
        this.listenersTerminalsWithCardsRemoved(removed);
        this.listenersTerminalsDetached(detached);
    }

    private void listenersInitialized() {
        this.listenersTerminalEventsInitialized();
        this.listenersCardEventsInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenersCardEventsInitialized() {
        HashSet<CardEventsListener> copyOfListeners;
        Set<CardEventsListener> set = this.cardEventsListeners;
        synchronized (set) {
            copyOfListeners = new HashSet<CardEventsListener>(this.cardEventsListeners);
        }
        for (CardEventsListener listener : copyOfListeners) {
            try {
                listener.cardEventsInitialized();
            }
            catch (Exception thrownInListener) {
                this.logger.error("Exception thrown in CardEventsListener.cardRemoved:" + thrownInListener.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenersTerminalEventsInitialized() {
        HashSet<CardTerminalEventsListener> copyOfListeners;
        Set<CardTerminalEventsListener> set = this.cardTerminalEventsListeners;
        synchronized (set) {
            copyOfListeners = new HashSet<CardTerminalEventsListener>(this.cardTerminalEventsListeners);
        }
        for (CardTerminalEventsListener listener : copyOfListeners) {
            try {
                listener.terminalEventsInitialized();
            }
            catch (Exception thrownInListener) {
                this.logger.error("Exception thrown in CardTerminalEventsListener.terminalAttached:" + thrownInListener.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenersTerminalsAttached(Set<CardTerminal> attached) {
        if (!attached.isEmpty()) {
            HashSet<CardTerminalEventsListener> copyOfListeners;
            Set<CardTerminalEventsListener> set = this.cardTerminalEventsListeners;
            synchronized (set) {
                copyOfListeners = new HashSet<CardTerminalEventsListener>(this.cardTerminalEventsListeners);
            }
            for (CardTerminal terminal : attached) {
                for (CardTerminalEventsListener listener : copyOfListeners) {
                    try {
                        listener.terminalAttached(terminal);
                    }
                    catch (Exception thrownInListener) {
                        this.logger.error("Exception thrown in CardTerminalEventsListener.terminalAttached:" + thrownInListener.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenersTerminalsDetached(Set<CardTerminal> detached) {
        if (!detached.isEmpty()) {
            HashSet<CardTerminalEventsListener> copyOfListeners;
            Set<CardTerminalEventsListener> set = this.cardTerminalEventsListeners;
            synchronized (set) {
                copyOfListeners = new HashSet<CardTerminalEventsListener>(this.cardTerminalEventsListeners);
            }
            for (CardTerminal terminal : detached) {
                for (CardTerminalEventsListener listener : copyOfListeners) {
                    try {
                        listener.terminalDetached(terminal);
                    }
                    catch (Exception thrownInListener) {
                        this.logger.error("Exception thrown in CardTerminalEventsListener.terminalDetached:" + thrownInListener.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenersTerminalsWithCardsRemoved(Set<CardTerminal> removed) {
        if (!removed.isEmpty()) {
            HashSet<CardEventsListener> copyOfListeners;
            Set<CardEventsListener> set = this.cardEventsListeners;
            synchronized (set) {
                copyOfListeners = new HashSet<CardEventsListener>(this.cardEventsListeners);
            }
            for (CardTerminal terminal : removed) {
                for (CardEventsListener listener : copyOfListeners) {
                    try {
                        listener.cardRemoved(terminal);
                    }
                    catch (Exception thrownInListener) {
                        this.logger.error("Exception thrown in CardEventsListener.cardRemoved:" + thrownInListener.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenersTerminalsWithCardsInserted(Set<CardTerminal> inserted) {
        if (!inserted.isEmpty()) {
            HashSet<CardEventsListener> copyOfListeners;
            Set<CardEventsListener> set = this.cardEventsListeners;
            synchronized (set) {
                copyOfListeners = new HashSet<CardEventsListener>(this.cardEventsListeners);
            }
            for (CardTerminal terminal : inserted) {
                Card card = null;
                if (this.autoconnect) {
                    try {
                        card = terminal.connect(this.protocol.getProtocol());
                    }
                    catch (CardException cex) {
                        this.logger.debug("terminal.connect(" + this.protocol.getProtocol() + ") failed. " + cex.getMessage());
                    }
                }
                for (CardEventsListener listener : copyOfListeners) {
                    try {
                        listener.cardInserted(terminal, card);
                    }
                    catch (Exception thrownInListener) {
                        this.logger.error("Exception thrown in CardEventsListener.cardInserted:" + thrownInListener.getMessage());
                    }
                }
            }
        }
    }

    private void sleepForDelay() throws InterruptedException {
        Thread.sleep(this.delay);
    }

    private void logCardException(CardException cex, String where) {
        this.logger.debug(where + ": " + cex.getMessage());
        this.logger.debug("no card readers connected?");
        Throwable cause = cex.getCause();
        if (cause == null) {
            return;
        }
        this.logger.debug("cause: " + cause.getMessage());
        this.logger.debug("cause type: " + cause.getClass().getName());
    }

    public static enum PROTOCOL {
        T0("T=0"),
        T1("T=1"),
        TCL("T=CL"),
        ANY("*");

        private final String protocol;

        private PROTOCOL(String protocol) {
            this.protocol = protocol;
        }

        String getProtocol() {
            return this.protocol;
        }
    }
}

