﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.session;
using ikvm.extensions;
using NUnit.Framework;
using lang = java.lang;
using java.util;
using joda = org.joda.time;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.api.domain.exception;
using be.ehealth.businessconnector.ehbox.api.utils;
using be.ehealth.businessconnector.ehbox.v3.builders;
using be.ehealth.businessconnector.ehbox.v3.exception;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using publication = be.fgov.ehealth.ehbox.publication.protocol.v3;
using be.fgov.ehealth.ehbox.core.v3;
using be.fgov.ehealth.ehbox.publication.protocol.v3;
using be.ehealth.businessconnector.ehbox.v3.session;
using be.ehealth.businessconnector.ehbox.v3.util;
using be.fgov.ehealth.ehbox.consultation.protocol.v3;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.ehboxv3.session
{
    [TestFixture]
    public class EhboxV3SendToMultipleDestinationsIntegrationTest
    {
    	
    	private static string SSIN = "74123045193";
    	
    	private static String currentMessageId;


        [SetUp]
        public void init() {
            java.util.Properties props = new java.util.Properties();
            props.put("session.environment", "acc");
            props.put("session.professionType", "persphysician");
            props.put("session.username", "olivier");
            SessionInitializer.init(props, true, SupportedLanguages.NET.getAbbreviation());
        }

        [TearDown]
        public void tearDown() {
            SessionDestroyer.destroy();
        }

        [Test]
        public void _00_sendMessage() {
            DocumentMessage msg = new DocumentMessage();

            msg.getDestinations().addAll(Arrays.asList(new Addressee(SSIN, QualityType.DOCTOR_SSIN),
                    new Addressee(SSIN, QualityType.PHARMACIST_SSIN)));

            Document doc = new Document();
            doc.setTitle("body");
            doc.setContent("body-eureka".getBytes());
            doc.setMimeType("text/html");
            doc.setFilename("body.html");
            msg.setBody(doc);

            Document annex = new Document();
            annex.setTitle("annex");
            annex.setContent("annex-eureka".getBytes());
            annex.setMimeType("text/html");
            annex.setFilename("annex.dump");
            msg.getAnnexList().add(annex);

            msg.setEncrypted(true);

            SendMessageRequest request = BuilderFactory.getSendMessageBuilder().buildMessage(msg);
            SendMessageResponse response = ServiceFactory.getEhealthBoxServiceV3().sendMessage(request);
            currentMessageId = response.getId();
        }

        [Test]
        public void _01_getAllEhboxesMessagesList() {
            GetAllEhboxesMessagesListResponse list = ServiceFactory.getEhealthBoxServiceV3()
                    .getAllEhboxesMessagesList(BuilderFactory.getRequestBuilder().createAllEhboxesMessagesListRequest("INBOX"));
            Set matchingMessages = new HashSet();
            Iterator it = list.getMessages().iterator();
			while (it.hasNext()) {
            	be.fgov.ehealth.ehbox.consultation.protocol.v3.Message message = (be.fgov.ehealth.ehbox.consultation.protocol.v3.Message) it.next();
                if (message.getMessageId().Equals(currentMessageId)) {
                    matchingMessages.add(message.getDestination().getQuality());
                }
            }
            ServiceFactory.getEhealthBoxServiceV3().getAllEhboxesMessagesList(BuilderFactory.getRequestBuilder().createAllEhboxesMessagesListRequest("INBOX"));
            Assert.IsTrue(matchingMessages.contains("PHARMACIST"), "Message should be in pharmacist profile's inbox");
            Assert.IsTrue(matchingMessages.contains("DOCTOR"), "Message should be in doctor profile's inbox");

        }

        [Test]
        public void _02_deleteMessages() {
        	Set messageSet = new HashSet();
        	messageSet.add(currentMessageId);
            EhboxTestUtilities.deleteMessages("INBOX", messageSet, EhboxTestDataBuilder.generateBoxId(SSIN, IdentifierType.SSIN.getType(IdentifierType.EHBOX), QualityType.DOCTOR_SSIN.getQuality()));
            EhboxTestUtilities.deleteMessages("INBOX", messageSet, EhboxTestDataBuilder.generateBoxId(SSIN, IdentifierType.SSIN.getType(IdentifierType.EHBOX), QualityType.PHARMACIST_SSIN.getQuality()));
        }
    }
}
