/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import be.fgov.ehealth.etee.crypto.policies.KeyType;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum SigningPolicy {
    RSASSA_PSS_SHA256(KeyType.RSA, 2048, "2.16.840.1.101.3.4.2.1", "SHA256WITHRSAANDMGF1", "1.2.840.113549.1.1.10", new String[0]),
    RSA_SHA256(KeyType.RSA, 1024, "2.16.840.1.101.3.4.2.1", "SHA256withRSA", "1.2.840.113549.1.1.11", "1.2.840.113549.1.1.1"),
    ECDSA_SHA256(KeyType.EC, 256, "2.16.840.1.101.3.4.2.1", "SHA256WITHECDSA", "1.2.840.10045.4.3.2", new String[0]),
    EHEALTH_CERT(KeyType.RSA, 2048, "2.16.840.1.101.3.4.2.1", "SHA256WITHRSAANDMGF1", "1.2.840.113549.1.1.10", new String[0]),
    EID(KeyType.RSA, 1024, "2.16.840.1.101.3.4.2.1", "SHA256withRSA", "1.2.840.113549.1.1.11", "1.2.840.113549.1.1.1"),
    WEB_AUTHN(KeyType.RSA, 2048, "2.16.840.1.101.3.4.2.1", "SHA256WITHRSAANDMGF1", "1.2.840.113549.1.1.10", new String[0]);

    private final KeyType keyType;
    private final int signKeySize;
    private final String digestAlgorithmOID;
    private final String signatureAlgorithmName;
    private final Set<String> encryptionAlgorithmOIDs;

    private SigningPolicy(KeyType keyType, int signKeySize, String digestAlgorithmOID, String signatureAlgorithmName, String encryptionAlgorithmOID, String ... altEncryptionAlgorithmOID) {
        this.keyType = keyType;
        this.signKeySize = signKeySize;
        this.digestAlgorithmOID = digestAlgorithmOID;
        this.signatureAlgorithmName = signatureAlgorithmName;
        this.encryptionAlgorithmOIDs = new LinkedHashSet<String>();
        this.encryptionAlgorithmOIDs.add(encryptionAlgorithmOID);
        if (altEncryptionAlgorithmOID != null) {
            Collections.addAll(this.encryptionAlgorithmOIDs, altEncryptionAlgorithmOID);
        }
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public int getSignKeySize() {
        return this.signKeySize;
    }

    public String getDigestAlgorithmOID() {
        return this.digestAlgorithmOID;
    }

    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    @Deprecated
    public String getEncryptionAlgorithmOID() {
        return this.encryptionAlgorithmOIDs.iterator().next();
    }

    @Deprecated
    public List<String> getAltEncryptionAlgorithmOIDs() {
        return this.encryptionAlgorithmOIDs.stream().skip(1L).collect(Collectors.toList());
    }

    public Set<String> getEncryptionAlgorithmOIDs() {
        return this.encryptionAlgorithmOIDs;
    }

    public static SigningPolicy getPolicyByKeyType(SigningPolicy policy, KeyType keyType) {
        switch (policy) {
            case EHEALTH_CERT: 
            case WEB_AUTHN: {
                return KeyType.EC == keyType ? ECDSA_SHA256 : RSASSA_PSS_SHA256;
            }
            case EID: {
                return KeyType.EC == keyType ? ECDSA_SHA256 : RSA_SHA256;
            }
        }
        if (policy.getKeyType() != keyType) {
            throw new IllegalArgumentException("Policy KeyType [" + (Object)((Object)policy.getKeyType()) + "] does not match given keyType [" + (Object)((Object)keyType) + "]");
        }
        return policy;
    }

    public static Set<SigningPolicy> getPolicySet(SigningPolicy source) {
        HashSet<SigningPolicy> targetPolicies = new HashSet<SigningPolicy>();
        switch (source) {
            case EHEALTH_CERT: 
            case WEB_AUTHN: {
                targetPolicies.add(RSASSA_PSS_SHA256);
                targetPolicies.add(ECDSA_SHA256);
                break;
            }
            case EID: {
                targetPolicies.add(RSA_SHA256);
                targetPolicies.add(ECDSA_SHA256);
                break;
            }
            default: {
                targetPolicies.add(source);
            }
        }
        return targetPolicies;
    }

    private static class DigestOIDs {
        public static final String SHA256 = "2.16.840.1.101.3.4.2.1";

        private DigestOIDs() {
        }
    }

    private static class EncryptionOIDs {
        public static final String RSA = "1.2.840.113549.1.1.1";
        public static final String RSASSA_PSS = "1.2.840.113549.1.1.10";
        public static final String RSA_SHA256 = "1.2.840.113549.1.1.11";
        public static final String ECDSA_SHA256 = "1.2.840.10045.4.3.2";

        private EncryptionOIDs() {
        }
    }
}

