/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler.wss4j;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.handler.AbstractWsSecurityHandler;
import be.ehealth.technicalconnector.handler.utils.WSSecurityCrypto;
import be.ehealth.technicalconnector.handler.wss4j.AlgorithmHelper;
import be.ehealth.technicalconnector.handler.wss4j.AlgorithmHelperFactory;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.service.sts.security.impl.SAMLHolderOfKeyToken;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecHeaderGeneratorWss4jImpl
implements AbstractWsSecurityHandler.WSSecHeaderGeneratorStep0,
AbstractWsSecurityHandler.WSSecHeaderGeneratorStep1,
AbstractWsSecurityHandler.WSSecHeaderGeneratorStep2,
AbstractWsSecurityHandler.WSSecHeaderGeneratorStep3,
AbstractWsSecurityHandler.WSSecHeaderGeneratorStep4 {
    public static final String DEFAULT_DIGEST_METHOD_ALGORITHM = "default.digest.method.algorithm";
    public static final String DEFAULT_SIGNATURE_METHOD_ALGORITHM = "default.signature.method.algorithm";
    public static final String WSSEC_MUSTUNDERSTAND = "be.ehealth.technicalconnector.handler.wss4j.WSSecHeaderGeneratorWss4jImpl.mustUnderstand";
    private SOAPPart soapPart;
    private WSSecHeader wsSecHeader;
    private WSSecSignature sign;
    private WSSecTimestamp wsSecTimeStamp;
    private String assertionId;
    private Credential cred;
    private SOAPMessageContext ctx;
    private ConfigValidator config = ConfigFactory.getConfigValidator();

    @Override
    public AbstractWsSecurityHandler.WSSecHeaderGeneratorStep1 on(SOAPMessage message) throws TechnicalConnectorException {
        try {
            Validate.notNull((Object)message);
            this.soapPart = message.getSOAPPart();
            this.wsSecHeader = new WSSecHeader((Document)this.soapPart);
            this.wsSecHeader.insertSecurityHeader();
            this.wsSecHeader.setMustUnderstand(Boolean.valueOf(this.config.getProperty(WSSEC_MUSTUNDERSTAND, "true")).booleanValue());
            this.sign = new WSSecSignature(this.wsSecHeader);
            this.sign.setAddInclusivePrefixes(false);
            return this;
        }
        catch (WSSecurityException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.HANDLER_ERROR, new Object[]{"unable to insert security header.", e});
        }
    }

    @Override
    public AbstractWsSecurityHandler.WSSecHeaderGeneratorStep1 on(SOAPMessageContext ctx) throws TechnicalConnectorException {
        Validate.notNull((Object)ctx);
        this.ctx = ctx;
        return this.on(ctx.getMessage());
    }

    @Override
    public AbstractWsSecurityHandler.WSSecHeaderGeneratorStep2 withTimeStamp(long ttl, TimeUnit unit) {
        this.withTimeStamp(new Duration(ttl, unit));
        return this;
    }

    @Override
    public AbstractWsSecurityHandler.WSSecHeaderGeneratorStep2 withTimeStamp(Duration duration) {
        this.wsSecTimeStamp = new WSSecTimestamp(this.wsSecHeader);
        this.wsSecTimeStamp.setTimeToLive((int)duration.convert(TimeUnit.SECONDS));
        this.wsSecTimeStamp.build();
        return this;
    }

    @Override
    public AbstractWsSecurityHandler.WSSecHeaderGeneratorStep3 withBinarySecurityToken(Credential cred) throws TechnicalConnectorException {
        this.cred = cred;
        return this;
    }

    @Override
    public AbstractWsSecurityHandler.WSSecHeaderGeneratorStep3 withSAMLToken(SAMLToken token) throws TechnicalConnectorException {
        this.cred = token;
        Element assertionElement = token.getAssertion();
        Element importedAssertionElement = (Element)this.soapPart.importNode((Node)assertionElement, true);
        Element securityHeaderElement = this.wsSecHeader.getSecurityHeaderElement();
        securityHeaderElement.appendChild(importedAssertionElement);
        this.assertionId = assertionElement.getAttribute("AssertionID");
        return this;
    }

    @Override
    public void sign(AbstractWsSecurityHandler.SignedParts ... parts) throws TechnicalConnectorException {
        try {
            if (this.cred instanceof SAMLHolderOfKeyToken && StringUtils.isNotEmpty((CharSequence)this.assertionId)) {
                this.sign.setKeyIdentifierType(12);
                this.sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                this.sign.setCustomTokenId(this.assertionId);
            } else {
                this.sign.setKeyIdentifierType(1);
            }
            AlgorithmHelper algorithmHelper = AlgorithmHelperFactory.getAlgorithmHelper(this.cred, this.ctx);
            this.sign.setDigestAlgo(algorithmHelper.determineDigestAlgo(this.cred));
            this.sign.setSignatureAlgorithm(algorithmHelper.determineSignatureAlgorithm(this.cred));
            WSSecurityCrypto crypto = new WSSecurityCrypto(this.cred.getPrivateKey(), this.cred.getCertificate());
            this.sign.prepare((Crypto)crypto);
            if (!(this.cred instanceof SAMLHolderOfKeyToken) || !StringUtils.isNotEmpty((CharSequence)this.assertionId)) {
                this.sign.appendBSTElementToHeader();
            }
            List referenceList = this.sign.addReferencesToSign(this.generateReferencesToSign(parts));
            if (!referenceList.isEmpty()) {
                this.sign.computeSignature(referenceList, false, null);
            }
        }
        catch (WSSecurityException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.HANDLER_ERROR, new Object[]{"unable to insert security header.", e});
        }
    }

    protected List<WSEncryptionPart> generateReferencesToSign(AbstractWsSecurityHandler.SignedParts[] parts) {
        ArrayList<WSEncryptionPart> signParts = new ArrayList<WSEncryptionPart>();
        block6: for (AbstractWsSecurityHandler.SignedParts part : parts) {
            switch (part) {
                case TIMESTAMP: {
                    Validate.notNull((Object)this.wsSecTimeStamp);
                    signParts.add(new WSEncryptionPart(this.wsSecTimeStamp.getId()));
                    continue block6;
                }
                case BODY: {
                    SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)this.soapPart.getDocumentElement());
                    signParts.add(new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content"));
                    continue block6;
                }
                case SAML_ASSERTION: {
                    Validate.notNull((Object)this.assertionId);
                    signParts.add(new WSEncryptionPart(this.assertionId));
                    continue block6;
                }
                case BST: {
                    signParts.add(new WSEncryptionPart(this.sign.getBSTTokenId()));
                    continue block6;
                }
            }
        }
        return signParts;
    }
}

