/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils.impl;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaxbContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbContextFactory.class);
    private static final Map<String, JAXBContext> CACHE = new HashMap<String, JAXBContext>();

    private JaxbContextFactory() {
        throw new UnsupportedOperationException();
    }

    public static void initJaxbContext(Package packageInstance) {
        try {
            JaxbContextFactory.getJaxbContextForPackage(packageInstance);
        }
        catch (Exception e) {
            LOG.warn("Unable to load JaxbContext for {}", (Object)packageInstance, (Object)e);
        }
    }

    public static void initJaxbContext(Class<?> keyClass, boolean override, Class<?> ... classesToBeBound) {
        try {
            String key = JaxbContextFactory.calculateKey(keyClass);
            JaxbContextFactory.getJaxbContextForClass(key, override, classesToBeBound);
        }
        catch (JAXBException e) {
            LOG.warn("Unable to load JaxbContext for {}", (Object)ArrayUtils.toString(classesToBeBound), (Object)e);
        }
    }

    public static void initJaxbContext(Class<?> ... classesToBeBound) {
        try {
            JaxbContextFactory.getJaxbContextForClass(classesToBeBound);
        }
        catch (JAXBException e) {
            LOG.warn("Unable to load JaxbContext for {}", (Object)ArrayUtils.toString(classesToBeBound), (Object)e);
        }
    }

    public static JAXBContext getJaxbContextForPackage(Package pack) {
        Validate.notNull((Object)pack);
        try {
            String key = pack.getName();
            JAXBContext context = CACHE.get(key);
            if (context == null) {
                context = JAXBContext.newInstance((String)key);
                CACHE.put(key, context);
            }
            return context;
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Unable to create jaxbContext for package" + pack.getName());
        }
    }

    public static JAXBContext getJaxbContextForClass(Class<?> ... classesToBeBound) throws JAXBException {
        String key = JaxbContextFactory.calculateKey(classesToBeBound);
        return JaxbContextFactory.getJaxbContextForClass(key, false, classesToBeBound);
    }

    private static JAXBContext getJaxbContextForClass(String key, boolean override, Class<?> ... classesToBeBound) throws JAXBException {
        JAXBContext context = null;
        if (!override) {
            context = CACHE.get(key);
        }
        if (context == null) {
            context = JAXBContext.newInstance((Class[])classesToBeBound);
            CACHE.put(key, context);
        }
        return context;
    }

    private static String calculateKey(Class<?> ... classesToBeBound) {
        int arrayLength = ArrayUtils.getLength(classesToBeBound);
        if (arrayLength == 0) {
            return null;
        }
        if (arrayLength == 1) {
            return classesToBeBound[0].getName();
        }
        TreeSet<String> keyList = new TreeSet<String>();
        for (Class<?> classToBeBound : classesToBeBound) {
            keyList.add(classToBeBound.getName());
        }
        MessageDigest complete = DigestUtils.getMd5Digest();
        for (String clazz : keyList) {
            complete.update(clazz.getBytes());
        }
        return new String(Base64.encode((byte[])complete.digest()));
    }

    public static void reset() {
        CACHE.clear();
    }
}

