﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.service.sts.utils;
using java.util.concurrent;
using NUnit.Framework;
using be.ehealth.technicalconnector.session.renew;

namespace be.ehealth.technicalconnector.session
{
	[TestFixture]
	public class SlidingWindowSessionManagerIntegrationTest : AbstractServiceIntegrationTest {
		
		/*Extract from RenewStrategy class*/
		private string PROP_AUTO_RENEW = "sessionmanager.activate.autorenew";
		
		[Test]
		public void test() {

			ConfigFactory.getConfigValidator().setProperty(SlidingWindowRenewStrategy.SLIDING_WINDOW_DIVIDER, "2400");
			ConfigFactory.getConfigValidator().setProperty(PROP_AUTO_RENEW, "true");
			SessionManager sessionmgmgt = Session.getInstance();

			sessionmgmgt.unloadSession();
			SessionItem session = sessionmgmgt.createFallbackSession(getSessionProps().getProperty("test.session.holderofkey.password"), getSessionProps().getProperty("test.session.encryption.password"));
			org.joda.time.DateTime beforeRenew = SAMLHelper.getNotOnOrAfterCondition(session.getSAMLToken().getAssertion());

			TimeUnit.SECONDS.sleep(60);

			org.joda.time.DateTime afterRenew = SAMLHelper.getNotOnOrAfterCondition(sessionmgmgt.getSession().getSAMLToken().getAssertion());

			Assert.IsTrue(afterRenew.isAfter(beforeRenew),"SlidingWindow Renew doesn't work!");
			sessionmgmgt.unloadSession();

		}
	}

}
