package be.fgov.ehealth.technicalconnector.bootstrap.bcp.parser;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;

public class StatusPageParserIntegrationTest {

    @Test
    public void production_v2()throws TechnicalConnectorException {
        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist.ehealth.fgov.be/servicelist.xml");
        EndPointInformation info = StatusPageParser.parse(xml);
    }
    @Test
    public void acceptance_V2() throws TechnicalConnectorException {
        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelistv2.xml");
        EndPointInformation info = StatusPageParser.parse(xml);

        Assert.assertEquals(1, info.getService2CacheInformation()
                                   .size());
        Assert.assertEquals(21, info.getService2AllEndpoints()
                                    .size());
        Assert.assertEquals(43, info.getUrl2Service()
                                    .size());
    }

    @Test
    public void acceptance_V1() throws TechnicalConnectorException {
        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelist.xml");
        EndPointInformation info = StatusPageParser.parse(xml);

        Assert.assertEquals(0, info.getService2CacheInformation()
                                   .size());
        Assert.assertEquals(21, info.getService2AllEndpoints()
                                    .size());
        Assert.assertEquals(43, info.getUrl2Service()
                                    .size());
    }
}
