/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.exception;

import org.junit.Assert;
import org.junit.Test;


/**
 * Test class to test the ExceptionFactory in isolation.
 * 
 * @author EHP
 * 
 * 
 */
public class ExceptionFactoryTest {


    /** * */
    @Test
    public void testCreateExceptionWithUnknownErrorCode() {
        // TechnicalConnectorException except = ExceptionFactory.createException(TechnicalConnectorException.class, "test", new Object[]{
        // "ttp://www.ehealth.fgov.be"
        // });
        // Assert.assertEquals("test", except.getErrorCode());
        // Assert.assertEquals("test", except.getLocalizedMessage());
    }

    /** * */
    @Test
    public void testCreateExceptionWithOneElementInContext() {
        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.MALFORMED_URL;
        TechnicalConnectorException except = new TechnicalConnectorException(errorValue, "ttp://www.ehealth.fgov.be");
        Assert.assertEquals("malformed.url", except.getErrorCode());
        Assert.assertEquals("Invalid url to ttp://www.ehealth.fgov.be file", except.getLocalizedMessage());
    }

    /** * */
    @Test
    public void testCreateExceptionWithMultipleElementsInContext() {
        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_CREATING_SOAP_FAULT;
        TechnicalConnectorException except = new TechnicalConnectorException(errorValue, "15", "7", "malformed.url");
        Assert.assertEquals("error.creating.soap.fault", except.getErrorCode());
        Assert.assertEquals("Error while creating soap fault for messageId: 15, clientId: 7, exception:malformed.url", except.getLocalizedMessage());
    }

    /** * */
    @Test
    public void testCreateExceptionWithToLittleElementsInContext() {
        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_CREATING_SOAP_FAULT;
        TechnicalConnectorException except = new TechnicalConnectorException(errorValue, "15", "7");
        Assert.assertEquals("error.creating.soap.fault", except.getErrorCode());
        Assert.assertEquals("Error while creating soap fault for messageId: 15, clientId: 7, exception:{2}", except.getLocalizedMessage());
    }

    /** * */
    @Test
    public void testCreateExceptionWithTrowable() {
        TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.MALFORMED_URL;
        TechnicalConnectorException except = new TechnicalConnectorException(errorValue, new Throwable("Typpo dude."), "ttp://www.ehealth.fgov.be");
        Assert.assertEquals("malformed.url", except.getErrorCode());
        Assert.assertEquals("Invalid url to ttp://www.ehealth.fgov.be file", except.getLocalizedMessage());
        Assert.assertEquals("Typpo dude.", except.getCause()
                                                 .getMessage());
    }

}
