/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public enum BeIDDigest {
    PLAIN_TEXT(new byte[]{48, -1, 48, 9, 6, 7, 96, 56, 1, 2, 1, 3, 1, 4, -1}),
    SHA_1(new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20}),
    SHA_224(new byte[]{48, 45, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 5, 0, 4, 28}),
    SHA_256(new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32}),
    SHA_384(new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48}),
    SHA_512(new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64}),
    RIPEMD_128(new byte[]{48, 29, 48, 9, 6, 5, 43, 36, 3, 2, 2, 5, 0, 4, 16}),
    RIPEMD_160(new byte[]{48, 33, 48, 9, 6, 5, 43, 36, 3, 2, 1, 5, 0, 4, 20}),
    RIPEMD_256(new byte[]{48, 45, 48, 9, 6, 5, 43, 36, 3, 2, 3, 5, 0, 4, 32}),
    SHA3_256(new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 8, 5, 0, 4, 32}),
    SHA3_384(new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 9, 5, 0, 4, 48}),
    SHA3_512(new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 10, 5, 0, 4, 64}),
    SHA_1_PSS(new byte[0], 16),
    SHA_256_PSS(new byte[0], 32),
    ECDSA_SHA_2_256(new byte[0], 1, true),
    ECDSA_SHA_2_384(new byte[0], 2, true),
    ECDSA_SHA_2_512(new byte[0], 4, true),
    ECDSA_SHA_3_256(new byte[0], 8, true),
    ECDSA_SHA_3_384(new byte[0], 16, true),
    ECDSA_SHA_3_512(new byte[0], 32, true),
    NONE(new byte[0]),
    ECDSA_NONE(new byte[0], 64, true);

    private final byte[] prefix;
    private final byte algorithmReference;
    private final boolean ec;

    private BeIDDigest(byte[] prefix, int algorithmReference, boolean ec) {
        this.prefix = prefix;
        this.algorithmReference = (byte)algorithmReference;
        this.ec = ec;
    }

    private BeIDDigest(byte[] prefix, int algorithmReference) {
        this(prefix, algorithmReference, false);
    }

    private BeIDDigest(byte[] prefix) {
        this(prefix, 1);
    }

    public static BeIDDigest getInstance(String name) {
        return BeIDDigest.valueOf(name);
    }

    public byte[] getPrefix(int valueLength) {
        if (this.equals((Object)PLAIN_TEXT)) {
            byte[] digestInfoPrefix = Arrays.copyOf(this.prefix, this.prefix.length);
            digestInfoPrefix[1] = (byte)(valueLength + 13);
            digestInfoPrefix[14] = (byte)valueLength;
            return digestInfoPrefix;
        }
        return this.prefix;
    }

    public byte getAlgorithmReference() {
        return this.algorithmReference;
    }

    public String getStandardName() {
        return this.name().replace('_', '-');
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.getStandardName());
    }

    public boolean isEc() {
        return this.ec;
    }
}

