/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.utils;

public final class ArrayTools {
    public static int indexOf(byte[] src, byte[] contained) {
        if (src == null) {
            throw new IllegalArgumentException("Source array can not be null");
        }
        int result = -1;
        if (src.length >= contained.length) {
            int pos;
            boolean found = false;
            for (pos = 0; pos <= src.length - contained.length && !found; ++pos) {
                boolean equals = true;
                for (int j = 0; j < contained.length && equals; ++j) {
                    equals = src[pos + j] == contained[j];
                    found = j == contained.length - 1 && equals;
                }
            }
            result = found ? pos - 1 : -1;
        }
        return result;
    }

    public static byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return new byte[0];
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    private ArrayTools() {
    }
}

