/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.FileType;
import be.fedict.commons.eid.client.impl.BeIDDigest;
import be.fedict.commons.eid.client.spi.UserCancelledException;
import be.fedict.commons.eid.jca.BeIDKeyStore;
import be.fedict.commons.eid.jca.UserCancelledSignatureException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeIDPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BeIDPrivateKey.class);
    private final FileType certificateFileType;
    private BeIDCard beIDCard;
    private final boolean logoff;
    private final boolean allowFailingLogoff;
    private final boolean autoRecovery;
    private final BeIDKeyStore beIDKeyStore;
    private static final Map<String, BeIDDigest> beIDDigests = new HashMap<String, BeIDDigest>();
    private final String applicationName;
    private X509Certificate authenticationCertificate;

    public BeIDPrivateKey(FileType certificateFileType, BeIDCard beIDCard, boolean logoff, boolean allowFailingLogoff, boolean autoRecovery, BeIDKeyStore beIDKeyStore, String applicationName) {
        LOGGER.debug("constructor: {}", (Object)certificateFileType);
        this.certificateFileType = certificateFileType;
        this.beIDCard = beIDCard;
        this.logoff = logoff;
        this.allowFailingLogoff = allowFailingLogoff;
        this.autoRecovery = autoRecovery;
        this.beIDKeyStore = beIDKeyStore;
        this.applicationName = applicationName;
    }

    @Override
    public String getAlgorithm() {
        if (this.beIDCard.isEC()) {
            return "EC";
        }
        return "RSA";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    byte[] sign(byte[] digestValue, String digestAlgo) throws SignatureException {
        byte[] signatureValue;
        block14: {
            LOGGER.debug("auto recovery: {}", (Object)this.autoRecovery);
            BeIDDigest beIDDigest = beIDDigests.get(digestAlgo);
            if (null == beIDDigest) {
                throw new SignatureException("unsupported algo: " + digestAlgo);
            }
            try {
                if (this.autoRecovery && null == this.authenticationCertificate) {
                    try {
                        this.authenticationCertificate = this.beIDCard.getAuthenticationCertificate();
                    }
                    catch (IOException | InterruptedException | CertificateException | CardException exception) {
                        // empty catch block
                    }
                }
                try {
                    signatureValue = this.beIDCard.sign(digestValue, beIDDigest, this.certificateFileType, false, this.applicationName);
                }
                catch (UserCancelledException | IOException | InterruptedException | CardException e) {
                    if (this.autoRecovery) {
                        X509Certificate newAuthenticationCertificate;
                        LOGGER.debug("trying to recover...");
                        this.beIDCard = this.beIDKeyStore.getBeIDCard(true);
                        if (null != this.authenticationCertificate && !this.authenticationCertificate.equals(newAuthenticationCertificate = this.beIDCard.getAuthenticationCertificate())) {
                            throw new SignatureException("different eID card");
                        }
                        signatureValue = this.beIDCard.sign(digestValue, beIDDigest, this.certificateFileType, false, this.applicationName);
                    }
                    throw e;
                }
                if (!this.logoff) break block14;
                try {
                    this.beIDCard.logoff();
                }
                catch (Exception e) {
                    if (this.allowFailingLogoff) {
                        LOGGER.error("eID logoff failed.");
                        break block14;
                    }
                    throw e;
                }
            }
            catch (Exception ex) {
                if (ex instanceof UserCancelledException) {
                    throw new UserCancelledSignatureException(ex);
                }
                throw new SignatureException(ex);
            }
        }
        return signatureValue;
    }

    static {
        beIDDigests.put("SHA-1", BeIDDigest.SHA_1);
        beIDDigests.put("SHA-224", BeIDDigest.SHA_224);
        beIDDigests.put("SHA-256", BeIDDigest.SHA_256);
        beIDDigests.put("SHA-384", BeIDDigest.SHA_384);
        beIDDigests.put("SHA-512", BeIDDigest.SHA_512);
        beIDDigests.put("NONE", BeIDDigest.NONE);
        beIDDigests.put("RIPEMD128", BeIDDigest.RIPEMD_128);
        beIDDigests.put("RIPEMD160", BeIDDigest.RIPEMD_160);
        beIDDigests.put("RIPEMD256", BeIDDigest.RIPEMD_256);
        beIDDigests.put("SHA-1-PSS", BeIDDigest.SHA_1_PSS);
        beIDDigests.put("SHA-256-PSS", BeIDDigest.SHA_256_PSS);
        beIDDigests.put("SHA-256-ECDSA", BeIDDigest.ECDSA_SHA_2_256);
        beIDDigests.put("SHA-384-ECDSA", BeIDDigest.ECDSA_SHA_2_384);
        beIDDigests.put("SHA-512-ECDSA", BeIDDigest.ECDSA_SHA_2_512);
        beIDDigests.put("SHA3-256-ECDSA", BeIDDigest.ECDSA_SHA_3_256);
        beIDDigests.put("SHA3-384-ECDSA", BeIDDigest.ECDSA_SHA_3_384);
        beIDDigests.put("SHA3-512-ECDSA", BeIDDigest.ECDSA_SHA_3_512);
        beIDDigests.put("NONE-ECDSA", BeIDDigest.ECDSA_NONE);
        beIDDigests.put("SHA3-256", BeIDDigest.SHA3_256);
        beIDDigests.put("SHA3-384", BeIDDigest.SHA3_384);
        beIDDigests.put("SHA3-512", BeIDDigest.SHA3_512);
    }
}

