/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataNotification;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierData;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierResult;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributes;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributesReceiver;
import be.fgov.ehealth.etee.crypto.decrypt.SigningTimeVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.SigningTimeVerifierResult;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.policies.SignatureLayer;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SignedDataVerifierOuter
extends SignedDataVerifierAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedDataVerifierOuter.class);
    private final SigningTimeVerifier signingTimeVerifier;

    public SignedDataVerifierOuter(Collection<SigningPolicy> signingPolicies, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesReceiver, SigningTimeVerifier signingTimeVerifier) {
        super(SignatureLayer.OUTER, signingPolicies, requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesReceiver);
        this.signingTimeVerifier = signingTimeVerifier;
    }

    @Override
    public CryptoResult<SignedDataVerifierData> verifySignedData(CMSMessageContext<?> cmsMsgContext, SignedDataVerifierData signVerificationData, SigningCredential ... signers) {
        SignedDataVerifierResult result = new SignedDataVerifierResult();
        SignerInformation signerInformation = cmsMsgContext.getSignerInformation();
        result.setContent(cmsMsgContext.getContentStream());
        result.setSignerInformation(signerInformation);
        result.setSignature(signerInformation.getSignature());
        SignerInfoAttributes signerInfoAttributes = this.getSignerInfoAttributes(result, signerInformation);
        Date signingTime = this.verifySigningTime(result, signerInfoAttributes);
        result.setSigningTime(signingTime);
        String subjectKeyIdentifier = this.getSubjectKeyIdentifier(cmsMsgContext);
        if (subjectKeyIdentifier != null) {
            result.setAuthenticationKeyIdentifier(subjectKeyIdentifier);
            LOGGER.info("Message Sender: PublicKey [" + subjectKeyIdentifier + "]");
            this.verifyPublicKey(result, cmsMsgContext, subjectKeyIdentifier, signers);
        } else {
            X509Certificate signerCertificate = cmsMsgContext.getAuthenticationCertificate();
            result.setAuthenticationCert(signerCertificate);
            if (signerCertificate == null) {
                LOGGER.warn(this.buildMsg("No Signer Certificate."));
                result.getErrors().add(SignedDataNotification.CERTIFICATE_EXPECTED_BUT_NOT_PRESENT.get(this.getLayer()));
                return result;
            }
            if (signers != null && signers.length > 0) {
                this.verifySigner(result, signerCertificate, signers);
            }
            LOGGER.info("Message Sender: X.509 Certificate [" + signerCertificate.getSerialNumber() + "]");
            this.verifyCertificate(result, cmsMsgContext, signerInfoAttributes, signingTime);
        }
        return result;
    }

    private Date verifySigningTime(SignedDataVerifierResult result, SignerInfoAttributes signerInfoAttributes) {
        Date signingTime;
        SigningTimeVerifierResult signingTimeResult = this.signingTimeVerifier.verify(signerInfoAttributes);
        result.copyNotifications(signingTimeResult);
        if (signingTimeResult.hasErrors()) {
            LOGGER.error(this.buildMsg("Signing Time validation completed with errors: " + signingTimeResult.getErrors()));
        }
        if ((signingTime = (Date)signingTimeResult.getData()) == null) {
            signingTime = new Date();
        }
        return signingTime;
    }
}

