/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.utils;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class SAMLConverter {
    private SAMLConverter() {
    }

    public static Element toElement(String assertion) throws TechnicalConnectorException {
        try {
            ByteArrayInputStream sbis = new ByteArrayInputStream(assertion.getBytes(Charset.UTF_8.getName()));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(sbis);
            return doc.getDocumentElement();
        }
        catch (SAXException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SAMLCONVERTER_ERROR, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SAMLCONVERTER_ERROR, (Throwable)e, new Object[0]);
        }
        catch (ParserConfigurationException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SAMLCONVERTER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public static String toXMLString(Element element) throws TechnicalConnectorException {
        try {
            DOMSource source = new DOMSource(element);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SAMLCONVERTER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public static Element convert(Source stsResponse) throws TechnicalConnectorException {
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(stsResponse, result);
            String xmlResponse = stringWriter.getBuffer().toString();
            return SAMLConverter.toElement(xmlResponse);
        }
        catch (TransformerException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.SAMLCONVERTER_ERROR, (Throwable)e, new Object[0]);
        }
    }
}

