/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarFileHandler
extends AbstractSOAPHandler {
    private static final String TIMINGS = "timings";
    private static final Logger LOG = LoggerFactory.getLogger(HarFileHandler.class);
    private DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String MESSAGE_ENDPOINT_ADDRESS = "javax.xml.ws.service.endpoint.address";
    private JsonObject harJson;
    private Long start;
    private Long recieved;
    private Long split;
    private String outputdir = ConfigFactory.getConfigValidator().getProperty("connector.output.dir", System.getProperty("java.io.tmpdir"));
    private static Properties applicationProps = new Properties();

    @Override
    public boolean handleFault(SOAPMessageContext ctx) {
        Boolean outbound = (Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound.booleanValue()) {
            return false;
        }
        this.handleMessage(ctx);
        return true;
    }

    @Override
    public boolean handleInbound(SOAPMessageContext context) {
        this.setHandler();
        SOAPMessage msg = context.getMessage();
        try {
            String[] header;
            String soapenv = this.getEnvelope(msg);
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("statusText", "OK");
            response.addProperty("httpVersion", "HTTP/1.1");
            response.add("headers", (JsonElement)this.handleHeaders(msg.getMimeHeaders()));
            response.add("cookies", (JsonElement)new JsonArray());
            JsonObject content = new JsonObject();
            content.addProperty("size", (Number)soapenv.getBytes().length);
            response.addProperty("headersSize", (Number)-1);
            response.addProperty("bodySize", (Number)-1);
            response.addProperty("redirectURL", "");
            content.addProperty("mimeType", "text/xml; charset=utf-8");
            if (msg.getMimeHeaders() != null && (header = msg.getMimeHeaders().getHeader("Content-Type")) != null && header.length > 0) {
                content.addProperty("mimeType", header[0]);
            }
            content.addProperty("text", soapenv);
            response.add("content", (JsonElement)content);
            this.getEntry().add("response", (JsonElement)response);
            this.getEntry().get(TIMINGS).getAsJsonObject().addProperty("wait", (Number)(this.recieved - this.split));
            long end = System.currentTimeMillis();
            this.getEntry().get(TIMINGS).getAsJsonObject().addProperty("receive", (Number)(end - this.recieved));
            this.getEntry().addProperty("time", (Number)(end - this.start));
            this.saveHar();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        this.setHandler();
        SOAPMessage msg = context.getMessage();
        try {
            JsonObject request = new JsonObject();
            request.addProperty("method", "POST");
            request.addProperty("url", context.get((Object)MESSAGE_ENDPOINT_ADDRESS).toString());
            request.addProperty("httpVersion", "HTTP/1.1");
            request.add("headers", (JsonElement)this.handleHeaders(msg.getMimeHeaders()));
            request.add("queryString", (JsonElement)new JsonArray());
            request.add("cookies", (JsonElement)new JsonArray());
            request.addProperty("headersSize", (Number)-1);
            request.add("postData", (JsonElement)this.getPostData(msg));
            request.addProperty("time", "1");
            request.addProperty("bodySize", (Number)-1);
            this.split = System.currentTimeMillis();
            this.getEntry().get(TIMINGS).getAsJsonObject().addProperty("send", (Number)(this.split - this.start));
            this.getEntry().add("request", (JsonElement)request);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void saveHar() throws IOException, TechnicalConnectorException {
        String fileName = IdGeneratorFactory.getIdGenerator("uuid").generateId() + ".har";
        File file = new File(this.outputdir, fileName);
        LOG.info("Writing har file on location: {}", (Object)file.getPath());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson((JsonElement)this.harJson, new JsonWriter((Writer)new FileWriter(file)));
    }

    private JsonObject getPostData(SOAPMessage msg) throws SOAPException, IOException {
        JsonObject postData = new JsonObject();
        postData.addProperty("mimeType", "multipart/form-data");
        postData.add("params", (JsonElement)new JsonArray());
        postData.addProperty("text", this.getEnvelope(msg));
        return postData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEnvelope(SOAPMessage message) throws SOAPException, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)stream);
            if (stream.size() < 1232896) {
                String string = stream.toString(Charset.UTF_8.getName());
                return string;
            }
            String string = "message to large to log";
            return string;
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)stream);
        }
    }

    private JsonArray handleHeaders(MimeHeaders headers) {
        JsonArray response = new JsonArray();
        if (headers != null) {
            Iterator headersIterator = headers.getAllHeaders();
            while (headersIterator.hasNext()) {
                MimeHeader mimheader = (MimeHeader)headersIterator.next();
                JsonObject header = new JsonObject();
                header.addProperty("name", mimheader.getName());
                header.addProperty("value", mimheader.getValue());
                response.add((JsonElement)header);
            }
        }
        return response;
    }

    private void prepareHarFile() {
        LOG.info("Start creating har file");
        JsonObject creator = new JsonObject();
        creator.addProperty("name", applicationProps.getProperty("application.name", "UNKOWN"));
        creator.addProperty("version", applicationProps.getProperty("application.version", "UNKOWN"));
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.addProperty("startedDateTime", this.dateFormatter.format(new Date()));
        entry.add("cache", (JsonElement)new JsonArray());
        entry.add(TIMINGS, (JsonElement)new JsonObject());
        entries.add((JsonElement)entry);
        JsonObject log = new JsonObject();
        log.addProperty("version", "1.2");
        log.add("creator", (JsonElement)creator);
        log.add("entries", (JsonElement)entries);
        this.harJson = new JsonObject();
        this.harJson.add("log", (JsonElement)log);
    }

    private JsonObject getEntry() {
        JsonObject log = (JsonObject)this.harJson.get("log");
        JsonArray entries = (JsonArray)log.get("entries");
        return (JsonObject)entries.get(0);
    }

    private void setHandler() {
        if (this.start == null) {
            this.start = System.currentTimeMillis();
        } else {
            this.recieved = System.currentTimeMillis();
        }
        if (this.harJson == null) {
            this.prepareHarFile();
        }
    }

    static {
        InputStream is = null;
        try {
            is = ConnectorIOUtils.getResourceAsStream("/application.properties");
            applicationProps.load(is);
        }
        catch (TechnicalConnectorException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)is);
        }
    }
}

