package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import org.junit.Assert;
import org.junit.Test;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import java.io.ByteArrayInputStream;

/**
 * @author EHP
 */
public class ConnectorXmlUtilsTest {

    @Test(expected = Exception.class)
    public void xmlBombPreventionTransformerFactory() throws Exception {
        LoggingUtils.bootstrap();
        ConfigFactory.getConfigValidator().getProperty("bootstrap");

        String xml = "<?xml version=\"1.0\"?>\n" +
                "<!DOCTYPE lolz [\n" +
                "<!ENTITY lol \"lol\">\n" +
                "<!ENTITY lol2 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n" +
                "<!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n" +
                "<!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n" +
                "<!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n" +
                "<!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n" +
                "<!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n" +
                "<!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n" +
                "<!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\n" +
                "]>\n" +
                "<lolz>&lol9;</lolz>";

        System.setProperty("jdk.xml.entityExpansionLimit", "0");

        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(xml.getBytes()));
        ConnectorXmlUtils.toString(streamSource);
    }

    @Test(expected = Exception.class)
    public void xmlBombPreventionBuilderFactory() throws Exception {
        LoggingUtils.bootstrap();
        ConfigFactory.getConfigValidator().getProperty("bootstrap");

        String xml = "<?xml version=\"1.0\"?>\n" +
                "<!DOCTYPE lolz [\n" +
                "<!ENTITY lol \"lol\">\n" +
                "<!ENTITY lol2 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n" +
                "<!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n" +
                "<!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n" +
                "<!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n" +
                "<!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n" +
                "<!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n" +
                "<!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n" +
                "<!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\n" +
                "]>\n" +
                "<lolz>&lol9;</lolz>";

        System.setProperty("jdk.xml.entityExpansionLimit", "0");

        ConnectorXmlUtils.toDocument(xml);

    }

    @Test
    public void xslt() throws Exception {
        LoggingUtils.bootstrap();
        String xml = "<soapenv:Fault xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n" +
                "\t<faultcode>soapenv:Server</faultcode>\n" +
                "\t<faultstring>SOA-02001: Service is not available. Please contact service desk.</faultstring>\n" +
                "\t<detail>\n" +
                "\t\t<urn:SystemError xmlns:urn=\"urn:be:fgov:ehealth:errors:soa:v1\" Id=\"Id-046c2d5fd78a8be91f7160d3\">\n" +
                "\t\t\t<Origin>Server</Origin>\n" +
                "\t\t\t<Code>SOA-02001</Code>\n" +
                "\t\t\t<Message xml:lang=\"en\">Service is not available. Please contact service desk.</Message>\n" +
                "\t\t\t<urn:Environment>Acceptation</urn:Environment>\n" +
                "\t\t</urn:SystemError>\n" +
                "\t</detail>\n" +
                "</soapenv:Fault>\n";
        String result = ConnectorXmlUtils.xslt(new DOMSource(ConnectorXmlUtils.toDocument(xml)), new StreamSource(ConnectorIOUtils.getResourceAsStream("/templates/bcp.switch.xslt")));
        System.out.println(result);
        Assert.assertEquals("SWITCH",result);
    }
}