/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.cert.CertPathCheckerBuilder;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionTokenChecker;
import be.fgov.ehealth.etee.crypto.encrypt.EncryptionTokenCheckerImpl;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerBuilder;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPOptions;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import be.fgov.ehealth.etee.crypto.utils.SecurityConfiguration;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public final class EncryptionTokenCheckerBuilder {
    private EncryptionTokenCheckerBuilder() {
    }

    public static OCSPPolicyStep newBuilder() {
        SecurityConfiguration.configure();
        return new Steps();
    }

    private static class Steps
    implements OCSPPolicyStep,
    TrustStoreStep,
    BuildStep {
        private OCSPPolicy ocspPolicy = OCSPPolicy.NONE;
        private Map<OCSPOption, Object> ocspOptions = OCSPOptions.create();
        private KeyStore trustStore;

        private Steps() {
        }

        @Override
        public EncryptionTokenChecker build() {
            OCSPOptions options = OCSPOptions.defaultOptions().set(OCSPOption.TRUST_STORE, this.trustStore).setAll(this.ocspOptions);
            OCSPChecker ocspChecker = OCSPCheckerBuilder.newBuilder().addOCSPPolicy(this.ocspPolicy, options).build();
            CertPathChecker certPathChecker = CertPathCheckerBuilder.newBuilder().addTrustStore(this.trustStore).build();
            return new EncryptionTokenCheckerImpl(ocspChecker, certPathChecker);
        }

        @Override
        public TrustStoreStep addOCSPPolicy(OCSPPolicy policy) {
            return this.addOCSPPolicy(policy, new HashMap<OCSPOption, Object>());
        }

        @Override
        public TrustStoreStep addOCSPPolicy(OCSPPolicy policy, Map<OCSPOption, Object> ocspOptions) {
            Preconditions.checkNotNull(policy, "OCSPPolicy cannot be null.");
            Preconditions.checkNotNull(ocspOptions, "OCSPOptions cannot be null.");
            this.ocspPolicy = policy == OCSPPolicy.NONE ? policy : OCSPPolicy.RECEIVER_OPTIONAL;
            this.ocspOptions = ocspOptions;
            return this;
        }

        @Override
        public BuildStep addTrustStore(KeyStore keyStore) {
            Preconditions.checkNotNull(keyStore, "TrustStore cannot be null.");
            this.trustStore = keyStore;
            return this;
        }
    }

    public static interface BuildStep {
        public EncryptionTokenChecker build();
    }

    public static interface TrustStoreStep {
        public BuildStep addTrustStore(KeyStore var1);
    }

    public static interface OCSPPolicyStep
    extends TrustStoreStep {
        public TrustStoreStep addOCSPPolicy(OCSPPolicy var1);

        public TrustStoreStep addOCSPPolicy(OCSPPolicy var1, Map<OCSPOption, Object> var2);
    }
}

