/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReader;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderException;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderFactory;
import be.fgov.ehealth.etee.crypto.decrypt.DataSealChecker;
import be.fgov.ehealth.etee.crypto.decrypt.DataSealCheckerResult;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierData;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributesReceiver;
import be.fgov.ehealth.etee.crypto.decrypt.TimeStampTrustResult;
import be.fgov.ehealth.etee.crypto.decrypt.TimeStampTrustService;
import be.fgov.ehealth.etee.crypto.decrypt.UnsealedData;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPData;
import be.fgov.ehealth.etee.crypto.policies.SigningCredential;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationFatal;
import be.fgov.ehealth.etee.crypto.utils.DataPipe;
import be.fgov.ehealth.etee.crypto.utils.DataPipeInMemory;
import be.fgov.ehealth.etee.crypto.utils.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRLException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.io.TeeInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataSealCheckerImpl
implements DataSealChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSealCheckerImpl.class);
    private final SignedDataVerifier outerSignedDataVerifier;
    private final TimeStampTrustService timeStampTrustService;
    private final SignerInfoAttributesReceiver signerInfoAttributesReceiver;
    private final boolean addRevocationValues;

    DataSealCheckerImpl(SignedDataVerifier outerSignedDataVerifier, SignerInfoAttributesReceiver signerInfoAttributesReceiver, TimeStampTrustService timeStampTrustService) {
        this(outerSignedDataVerifier, signerInfoAttributesReceiver, false, timeStampTrustService);
    }

    DataSealCheckerImpl(SignedDataVerifier outerSignedDataVerifier, SignerInfoAttributesReceiver signerInfoAttributesReceiver, boolean addRevocationValues, TimeStampTrustService timeStampTrustService) {
        this.outerSignedDataVerifier = outerSignedDataVerifier;
        this.signerInfoAttributesReceiver = signerInfoAttributesReceiver;
        this.timeStampTrustService = timeStampTrustService;
        this.addRevocationValues = addRevocationValues;
    }

    @Override
    public final CryptoResult<UnsealedData> validate(byte[] data) {
        return this.processValidation(data, null, null, null, new SigningCredential[0]);
    }

    @Override
    public final CryptoResult<UnsealedData> validate(byte[] data, SigningCredential ... signers) {
        return this.processValidation(data, null, null, null, signers);
    }

    @Override
    public final CryptoResult<UnsealedData> validate(InputStream data, OutputStream verifiedData) {
        return this.validate(data, verifiedData, (DataPipe)null);
    }

    @Override
    public final CryptoResult<UnsealedData> validate(InputStream data, OutputStream verifiedData, SigningCredential ... signers) {
        return this.validate(data, verifiedData, (DataPipe)null, signers);
    }

    @Override
    public final CryptoResult<UnsealedData> validate(InputStream data, OutputStream verifiedData, DataPipe pipe) {
        return this.validate(data, verifiedData, pipe, (SigningCredential[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CryptoResult<UnsealedData> validate(InputStream data, OutputStream verifiedData, DataPipe pipe, SigningCredential ... signers) {
        try {
            CryptoResult<UnsealedData> cryptoResult = this.processValidation(null, data, verifiedData, pipe, signers);
            return cryptoResult;
        }
        finally {
            Streams.closeQuietly(verifiedData);
        }
    }

    @Override
    public CryptoResult<UnsealedData> stamp(byte[] data, byte[] timestamp) {
        return this.processStamp(data, null, null, null, timestamp);
    }

    @Override
    public CryptoResult<UnsealedData> stamp(InputStream data, OutputStream stampedData, byte[] timestamp) {
        return this.stamp(data, stampedData, timestamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CryptoResult<UnsealedData> stamp(InputStream data, OutputStream stampedData, byte[] timestamp, DataPipe inPipe) {
        try {
            CryptoResult<UnsealedData> cryptoResult = this.processStamp(null, data, stampedData, inPipe, timestamp);
            return cryptoResult;
        }
        finally {
            Streams.closeQuietly(stampedData);
        }
    }

    private CryptoResult<UnsealedData> processValidation(byte[] data, InputStream dataStream, OutputStream verifiedData, DataPipe pipe, SigningCredential ... signers) {
        DataSealCheckerResult result = new DataSealCheckerResult();
        try {
            SignedDataVerifierData verificationData = data != null ? this.getVerificationData(data, result, signers) : this.getVerificationData(dataStream, verifiedData, pipe, result, signers);
            result.setAuthenticationCert(verificationData.getAuthenticationCert());
            result.setAuthenticationKeyIdentifier(verificationData.getAuthenticationKeyIdentifier());
            result.setSignature(verificationData.getSignature());
            result.setSigningTime(verificationData.getSigningTime());
            return result;
        }
        catch (CMSReaderException e) {
            return this.handleCMSReaderMessage(e);
        }
        catch (CRLException e) {
            LOGGER.error("RevocationValues could not be retrieved.", (Throwable)e);
            return new DataSealCheckerResult(NotificationFatal.OUTER_SIGNED_DATA_STRUCTURE_INCORRECT);
        }
        catch (IOException e) {
            LOGGER.error("RevocationValues could not be added to the SignerInfo", (Throwable)e);
            return new DataSealCheckerResult(NotificationFatal.OUTER_SIGNED_DATA_STRUCTURE_INCORRECT);
        }
        catch (CMSException e) {
            LOGGER.error("SignerInfo of CMS Message could not be updated.", (Throwable)e);
            return new DataSealCheckerResult(NotificationFatal.OUTER_SIGNED_DATA_STRUCTURE_INCORRECT);
        }
    }

    private SignedDataVerifierData getVerificationData(byte[] data, DataSealCheckerResult result, SigningCredential ... signers) throws CMSReaderException, IOException, CRLException, CMSException {
        CMSMessageContext<byte[]> cmsMsgContext = new CMSMessageContext<byte[]>(data);
        CMSReader<byte[]> cmsMsgReader = CMSReaderFactory.getInstance().createByteArrayReader();
        cmsMsgReader.read(cmsMsgContext);
        CryptoResult<SignedDataVerifierData> signedDataVerifierResult = this.outerSignedDataVerifier.verifySignedData(cmsMsgContext, null, signers);
        result.copyNotifications(signedDataVerifierResult);
        SignedDataVerifierData verificationData = signedDataVerifierResult.getData();
        OCSPData ocspData = verificationData.getOcspData();
        if (this.addRevocationValues && ocspData != null) {
            SignerInformation signerInfo = verificationData.getSignerInformation();
            RevocationValues revocationValues = this.signerInfoAttributesReceiver.buildRevocationValues(ocspData);
            SignerInformationStore signerInfoStore = this.signerInfoAttributesReceiver.addRevocationValues(signerInfo, revocationValues);
            CMSSignedData updatedCmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)new CMSSignedData(data), (SignerInformationStore)signerInfoStore);
            result.setContent(Streams.fromBytes(updatedCmsSignedData.getEncoded()));
        } else {
            result.setContent(Streams.fromBytes(data));
        }
        return verificationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignedDataVerifierData getVerificationData(InputStream data, OutputStream verifiedData, DataPipe pipe, DataSealCheckerResult result, SigningCredential ... signers) throws CMSReaderException, IOException, CRLException, CMSException {
        DataPipe dataBeforeRevocation = pipe;
        if (this.addRevocationValues && dataBeforeRevocation == null) {
            dataBeforeRevocation = new DataPipeInMemory(Streams.DEFAULT_BUFFER_SIZE);
        }
        try {
            CMSMessageContext<TeeInputStream> cmsMsgContext = new CMSMessageContext<TeeInputStream>(new TeeInputStream(data, this.addRevocationValues ? dataBeforeRevocation.getTo() : verifiedData));
            CMSReader<InputStream> cmsMsgReader = CMSReaderFactory.getInstance().createStreamReader();
            cmsMsgReader.read(cmsMsgContext);
            CryptoResult<SignedDataVerifierData> signedDataVerifierResult = this.outerSignedDataVerifier.verifySignedData(cmsMsgContext, null, signers);
            if (signedDataVerifierResult.hasErrors() || signedDataVerifierResult.hasWarnings()) {
                result.copyNotifications(signedDataVerifierResult);
            }
            SignedDataVerifierData verificationData = signedDataVerifierResult.getData();
            OCSPData ocspData = verificationData.getOcspData();
            if (this.addRevocationValues && ocspData != null) {
                SignerInformation signerInfo = verificationData.getSignerInformation();
                RevocationValues revocationValues = this.signerInfoAttributesReceiver.buildRevocationValues(ocspData);
                SignerInformationStore signerInfoStore = this.signerInfoAttributesReceiver.addRevocationValues(signerInfo, revocationValues);
                CMSSignedDataParser.replaceSigners((InputStream)dataBeforeRevocation.getFrom(), (SignerInformationStore)signerInfoStore, (OutputStream)verifiedData);
            }
            SignedDataVerifierData signedDataVerifierData = verificationData;
            return signedDataVerifierData;
        }
        finally {
            Streams.closeQuietly(dataBeforeRevocation);
        }
    }

    private CryptoResult<UnsealedData> processStamp(byte[] data, InputStream dataStream, OutputStream stampedData, DataPipe inPipe, byte[] timestamp) {
        try {
            return data != null ? this.addStampToSignerInfo(data, timestamp) : this.addStampToSignerInfo(dataStream, stampedData, inPipe, timestamp);
        }
        catch (CMSReaderException e) {
            return this.handleCMSReaderMessage(e);
        }
        catch (CMSException e) {
            LOGGER.error("Invalid CMS structure", (Throwable)e);
            return new DataSealCheckerResult(NotificationFatal.ENVELOPED_DATA_STRUCTURE_INCORRECT);
        }
        catch (Exception e) {
            LOGGER.error("Could not add timestamp to sealed data", (Throwable)e);
            return new DataSealCheckerResult(NotificationFatal.STAMP_FAILED);
        }
    }

    private DataSealCheckerResult addStampToSignerInfo(byte[] data, byte[] timestamp) throws CMSReaderException, IOException, TSPException, CMSException {
        DataSealCheckerResult result = new DataSealCheckerResult();
        CMSMessageContext<byte[]> cmsMsgContext = new CMSMessageContext<byte[]>(data);
        CMSReader<byte[]> cmsMsgReader = CMSReaderFactory.getInstance().createByteArrayReader();
        cmsMsgReader.read(cmsMsgContext);
        SignerInformation signerInformation = cmsMsgContext.getSignerInformation();
        if (signerInformation != null) {
            SignerInformationStore signerInfoStore = this.updateSignerInformation(timestamp, result, signerInformation);
            CMSSignedData updatedCmsSignedData = CMSSignedData.replaceSigners((CMSSignedData)new CMSSignedData(data), (SignerInformationStore)signerInfoStore);
            result.setContent(Streams.fromBytes(updatedCmsSignedData.getEncoded()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CryptoResult<UnsealedData> addStampToSignerInfo(InputStream data, OutputStream stampedData, DataPipe inPipe, byte[] timestamp) throws CMSReaderException, IOException, TSPException, CMSException {
        DataSealCheckerResult result = new DataSealCheckerResult();
        DataPipe pipe = inPipe;
        if (pipe == null) {
            pipe = new DataPipeInMemory(Streams.DEFAULT_BUFFER_SIZE);
        }
        try {
            CMSMessageContext<TeeInputStream> cmsMsgContext = new CMSMessageContext<TeeInputStream>(new TeeInputStream(data, pipe.getTo()));
            CMSReader<InputStream> cmsMsgReader = CMSReaderFactory.getInstance().createStreamReader();
            cmsMsgReader.read(cmsMsgContext);
            SignerInformation signerInformation = cmsMsgContext.getSignerInformation();
            if (signerInformation != null) {
                SignerInformationStore signerInfoStore = this.updateSignerInformation(timestamp, result, signerInformation);
                CMSSignedDataParser.replaceSigners((InputStream)pipe.getFrom(), (SignerInformationStore)signerInfoStore, (OutputStream)stampedData);
            }
        }
        finally {
            Streams.closeQuietly(pipe);
        }
        return result;
    }

    private SignerInformationStore updateSignerInformation(byte[] timestamp, DataSealCheckerResult result, SignerInformation signerInformation) throws IOException, TSPException {
        ASN1Primitive derEncodedTimeStamp = this.signerInfoAttributesReceiver.readASN1Data(timestamp);
        TimeStampToken timeStampToken = this.signerInfoAttributesReceiver.readTimeStampToken(derEncodedTimeStamp);
        TimeStampTrustResult trustResult = this.timeStampTrustService.verify(timeStampToken, signerInformation);
        result.copyNotifications(trustResult);
        return this.signerInfoAttributesReceiver.addTimeStamp(signerInformation, derEncodedTimeStamp);
    }

    private CryptoResult<UnsealedData> handleCMSReaderMessage(CMSReaderException e) {
        LOGGER.error("Error reading message.", (Throwable)e);
        return new DataSealCheckerResult(NotificationFatal.getOuterFailureForMessage(e.getMessage()));
    }
}

