package be.ehealth.technicalconnector.utils;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.ConfigurationFakeRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.LoggingRule;
import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import java.util.List;
import java.util.Properties;

public class ConfigurableFactoryHelperTest {

    public interface Provider{

    }

    public static class ProviderValid implements Provider {

    }

    @Deprecated
    public static class ProviderDeprecated implements Provider {

    }

    public TestAppender appender = new TestAppender();

    @Rule
    public ConfigurationFakeRule configurationFakeRule = new ConfigurationFakeRule();

    @Rule
    public LoggingRule logging = LoggingRule.with().consoleAppender().and().appender(appender).build();


    @Test
    public void withDeprecatedClass() throws Exception {
        Provider provider = new ConfigurableFactoryHelper<Provider>("be.ehealth.technicalconnector.utils.provider", ProviderDeprecated.class.getName()).getImplementation();

        List<LoggingEvent> logEvents = appender.getLogEvents(ConfigurableFactoryHelper.class);
        Assert.assertEquals(1, logEvents.size());
        Assert.assertEquals("Instantiating a deprecated class [be.ehealth.technicalconnector.utils.ConfigurableFactoryHelperTest$ProviderDeprecated], please verify the javadoc!", logEvents.get(0).getMessage());

        Assert.assertEquals(ProviderDeprecated.class, provider.getClass());
    }

    @Test
    public void withNormalClass() throws Exception {
        Provider provider = new ConfigurableFactoryHelper<Provider>("be.ehealth.technicalconnector.utils.provider", ProviderValid.class.getName()).getImplementation();

        List<LoggingEvent> logEvents = appender.getLogEvents(ConfigurableFactoryHelper.class);
        Assert.assertEquals(0, logEvents.size());


        Assert.assertEquals(ProviderValid.class, provider.getClass());
    }

}