﻿using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.session;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.ws
{
	using System;
	using System.IO;
	using System.Text;
	using org.apache.commons.codec.binary;

	using be.ehealth.technicalconnector.handler;
	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.enumeration;
	using be.ehealth.technicalconnector.exception;
	using be.ehealth.technicalconnector.service;
	using be.ehealth.technicalconnector.service.etee;
	using be.ehealth.technicalconnector.service.etee.impl;
	using be.ehealth.technicalconnector.service.keydepot;
	using be.ehealth.technicalconnector.service.keydepot.impl;
	using be.ehealth.technicalconnector.service.kgss;
	using be.ehealth.technicalconnector.service.kgss.impl;
	using be.ehealth.technicalconnector.service.sts;
	using be.ehealth.technicalconnector.service.sts.domain;
	using be.ehealth.technicalconnector.service.sts.impl;
	using be.ehealth.technicalconnector.service.sts.security;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.service.etee.domain;
	using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.etee.kgss._1_0.protocol;
	using be.fgov.ehealth.etkdepot._1_0.protocol;
	using java.util;
	using be.ehealth.technicalconnector.utils.impl;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;
	using be.ehealth.technicalconnector.ws;
	using be.ehealth.technicalconnector.ws.domain;
	using be.ehealth.technicalconnector.ws.impl;
	using be.fgov.ehealth.etee.crypto.utils;

	using NUnit.Framework;

	using org.w3c.dom;

	/**
	 * The Class TestGenericWsSender.
	 */
	[TestFixture]
	class GenericWsSAMLSecuredITTest : be.ehealth.technicalconnector.session.AbstractServiceIntegrationTest
	{
		#region Fields

		private static java.util.Properties props;
		
		#endregion Fields
		
		#region Methods

		[SetUp]
		public static void init()
		{
			props = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net");
		}

		/**
		 * This operation tests the invocation of a SAML Assertion / STS Token secured web service. It is clear that as pre-requisite a valid
		 * STS Token retrieved via the STS Service is required.
		 * 
		 * This test includes the following main steps:
		 * <li>1. Set the URL to the web service end-point
		 * <li>2. Requesting a new STS Token/SAML Assertion via the STS Service
		 * <li>3. Creation of the body pay-load to send to the secured web service
		 * <li>4. Invoke the web service and obtain the response as {@link String}
		 */
		[Test]
		public void testSendSAMLSecured() {
			Assert.IsNotNull(invoke().asString());
		}

		/**
		 * This operation tests the invocation of a SAML Assertion / STS Token secured web service. It is clear that as pre-requisite a valid
		 * STS Token retrieved via the STS Service is required.
		 * 
		 * This test includes the following main steps:
		 * <li>1. Set the URL to the web service end-point
		 * <li>2. Requesting a new STS Token/SAML Assertion via the STS Service
		 * <li>3. Creation of the body pay-load to send to the secured web service
		 * <li>4. Invoke the web service and obtain the response as {@link Node}
		 */
		[Test]
		public void testSendSAMLSecuredDOM() {
			Assert.IsNotNull(invoke().asNode());
		}

		/**
		 * Helper method to generate and invoke the service.
		 */
		private GenericResponse invoke() {
			GenericRequest request = new GenericRequest();
			request.setEndpoint(props.getProperty("test.secured.endpoint"));
			request.setCredential(getToken(), TokenType.SAML);
			request.addDefaulHandlerChain();
			request.setPayload(getPayload());

			GenericWsSender sender = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender();

			return sender.send(request);
		}

		/**
		 * Helper method obtain an SAML Assertion
		 */
		private SAMLToken getToken() {
			Credential authentication = new KeyStoreCredential(props.getProperty("test.keystore.location"), props.getProperty("test.keystore.alias"), props.getProperty("test.keystore.password"));
			Credential service = new KeyStoreCredential(props.getProperty("test.keystore.location"), props.getProperty("test.keystore.alias"), props.getProperty("test.keystore.password"));


			// create the list of SAML Attributes Designators
			java.util.List designators = new ArrayList();
			designators.add(new SAMLAttributeDesignator("urn:be:fgov:ehealth:1.0:certificateholder:person:ssin", "urn:be:fgov:identification-namespace"));
			designators.add(new SAMLAttributeDesignator("urn:be:fgov:person:ssin", "urn:be:fgov:identification-namespace"));

			// create the list of SAML Attributes
			java.util.List attributes = new ArrayList();
			attributes.add(new SAMLAttribute("urn:be:fgov:person:ssin", "urn:be:fgov:identification-namespace", props.getProperty("test.INSS")));
			attributes.add(new SAMLAttribute("urn:be:fgov:ehealth:1.0:certificateholder:person:ssin", "urn:be:fgov:identification-namespace", props.getProperty("test.INSS")));

			// get the token
			STSService sts = STSServiceFactory.getInstance();
			Element assertion = sts.getToken(authentication, service, attributes, designators, AbstractSTSService.HOK_METHOD, 24);

			return SAMLTokenFactory.getInstance().createSamlToken(assertion, service);
		}


		/**
		 * Builds the payload (string) for the request.
		 */
		private String getPayload() {
			StringBuilder sb = new StringBuilder();
			sb.Append("<CheckBrokeredAccessControlRequest xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:v1\">");
			sb.Append("<Message xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">Hello this is your captain speeking</Message>");
			sb.Append("<Timestamp xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">");
			sb.Append(DateUtils.printDateTime(new org.joda.time.DateTime()));
			sb.Append("</Timestamp>");
			sb.Append("</CheckBrokeredAccessControlRequest>");
			return sb.ToString();

		}

		#endregion Methods
	}
}