/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.StringBody;

public class HttpRequest
extends Not {
    NottableString method = NottableString.string("");
    NottableString path = NottableString.string("");
    Map<NottableString, Parameter> queryStringParameters = new LinkedHashMap<NottableString, Parameter>();
    Body body = null;
    Map<NottableString, Header> headers = new LinkedHashMap<NottableString, Header>();
    Map<NottableString, Cookie> cookies = new LinkedHashMap<NottableString, Cookie>();
    Boolean keepAlive = null;
    Boolean secure = null;

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static HttpRequest request(String path) {
        return new HttpRequest().withPath(path);
    }

    public Boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequest withKeepAlive(Boolean isKeepAlive) {
        this.keepAlive = isKeepAlive;
        return this;
    }

    public Boolean isSecure() {
        return this.secure;
    }

    public HttpRequest withSecure(Boolean isSsl) {
        this.secure = isSsl;
        return this;
    }

    public HttpRequest withMethod(String method) {
        return this.withMethod(NottableString.string(method));
    }

    public HttpRequest withMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getMethod() {
        return this.method;
    }

    public String getMethod(String defaultValue) {
        if (Strings.isNullOrEmpty((String)this.method.getValue())) {
            return defaultValue;
        }
        return this.method.getValue();
    }

    public HttpRequest withPath(String path) {
        this.withPath(NottableString.string(path));
        return this;
    }

    public HttpRequest withPath(NottableString path) {
        this.path = path;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public boolean matches(String method, String path) {
        return this.method.getValue().equals(method) && this.path.getValue().equals(path);
    }

    public HttpRequest withQueryStringParameters(List<Parameter> parameters) {
        this.queryStringParameters.clear();
        for (Parameter parameter : parameters) {
            this.withQueryStringParameter(parameter);
        }
        return this;
    }

    public HttpRequest withQueryStringParameters(Parameter ... parameters) {
        return this.withQueryStringParameters(Arrays.asList(parameters));
    }

    public HttpRequest withQueryStringParameters(Map<String, List<String>> parameters) {
        this.queryStringParameters.clear();
        for (String name : parameters.keySet()) {
            for (String value : parameters.get(name)) {
                this.withQueryStringParameter(new Parameter(name, value));
            }
        }
        return this;
    }

    public HttpRequest withQueryStringParameter(Parameter parameter) {
        if (this.queryStringParameters.containsKey(parameter.getName())) {
            this.queryStringParameters.get(parameter.getName()).addNottableValues(parameter.getValues());
        } else {
            this.queryStringParameters.put(parameter.getName(), parameter);
        }
        return this;
    }

    public HttpRequest withQueryStringParameter(String name, String ... values) {
        if (this.queryStringParameters.containsKey(NottableString.string(name))) {
            this.queryStringParameters.get(NottableString.string(name)).addValues(values);
        } else {
            this.queryStringParameters.put(NottableString.string(name), Parameter.param(name, values));
        }
        return this;
    }

    public HttpRequest withQueryStringParameter(NottableString name, NottableString ... values) {
        if (this.queryStringParameters.containsKey(name)) {
            this.queryStringParameters.get(name).addValues(values);
        } else {
            this.queryStringParameters.put(name, Parameter.param(name, values));
        }
        return this;
    }

    public List<Parameter> getQueryStringParameters() {
        return new ArrayList<Parameter>(this.queryStringParameters.values());
    }

    public boolean hasQueryStringParameter(String name, String expectedValue) {
        return this.hasQueryStringParameter(NottableString.string(name), NottableString.string(expectedValue));
    }

    public boolean hasQueryStringParameter(NottableString name, NottableString expectedValue) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        if (expectedValue == null) {
            throw new IllegalArgumentException("Expected value must not be null");
        }
        Parameter parameter = this.queryStringParameters.get(name);
        if (parameter != null) {
            for (NottableString actualValue : parameter.getValues()) {
                if (!expectedValue.equals(actualValue)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpRequest withBody(String body) {
        this.body = new StringBody(body);
        return this;
    }

    public HttpRequest withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
        }
        return this;
    }

    public HttpRequest withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    public HttpRequest withBody(Body body) {
        this.body = body;
        return this;
    }

    public Body getBody() {
        return this.body;
    }

    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public HttpRequest withHeaders(List<Header> headers) {
        this.headers.clear();
        for (Header header : headers) {
            this.withHeader(header);
        }
        return this;
    }

    public HttpRequest withHeaders(Header ... headers) {
        if (headers != null) {
            this.withHeaders(Arrays.asList(headers));
        }
        return this;
    }

    public HttpRequest withHeader(Header header) {
        if (this.headers.containsKey(header.getName())) {
            this.headers.get(header.getName()).addNottableValues(header.getValues());
        } else {
            this.headers.put(header.getName(), header);
        }
        return this;
    }

    public HttpRequest withHeader(String name, String ... values) {
        if (this.headers.containsKey(NottableString.string(name))) {
            this.headers.get(NottableString.string(name)).addValues(values);
        } else {
            this.headers.put(NottableString.string(name), Header.header(name, values));
        }
        return this;
    }

    public HttpRequest withHeader(NottableString name, NottableString ... values) {
        if (this.headers.containsKey(name)) {
            this.headers.get(name).addValues(values);
        } else {
            this.headers.put(name, Header.header(name, values));
        }
        return this;
    }

    public HttpRequest replaceHeader(Header header) {
        for (NottableString key : new HashSet<NottableString>(this.headers.keySet())) {
            if (!header.getName().getValue().equalsIgnoreCase(key.getValue()) || header.getName().isNot() != key.isNot()) continue;
            this.headers.remove(key);
        }
        this.headers.put(header.getName(), header);
        return this;
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(this.headers.values());
    }

    public String getFirstHeader(String name) {
        String firstHeadValue = "";
        Header header = this.headers.get(NottableString.string(name));
        if (header == null) {
            header = this.headers.get(NottableString.string(name.toLowerCase()));
        }
        if (header == null) {
            header = this.headers.get(NottableString.string(name).capitalize());
        }
        if (header != null && !header.getValues().isEmpty() && !Strings.isNullOrEmpty((String)header.getValues().get(0).getValue())) {
            firstHeadValue = header.getValues().get(0).getValue();
        }
        return firstHeadValue;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(NottableString.string(name)) || this.headers.containsKey(NottableString.string(name.toLowerCase()));
    }

    public HttpRequest withCookies(List<Cookie> cookies) {
        this.cookies.clear();
        for (Cookie cookie : cookies) {
            this.withCookie(cookie);
        }
        return this;
    }

    public HttpRequest withCookies(Cookie ... cookies) {
        if (cookies != null) {
            this.withCookies(Arrays.asList(cookies));
        }
        return this;
    }

    public HttpRequest withCookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
        return this;
    }

    public HttpRequest withCookie(String name, String value) {
        this.cookies.put(NottableString.string(name), Cookie.cookie(name, value));
        return this;
    }

    public HttpRequest withCookie(NottableString name, NottableString value) {
        this.cookies.put(name, Cookie.cookie(name, value));
        return this;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }
}

