/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.beid;

import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;


/**
 * Dummy card
 * 
 * @author EHP
 * 
 */
public class DummyCard extends Card {

    private CardChannel channel = new DummyChannel(this);

    @Override
    public ATR getATR() {
        try {
            return new ATR(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/beid/Alice_ATR.bin")));
        } catch (TechnicalConnectorException e) {
            throw new IllegalArgumentException(e);
        }
    }


    @Override
    public String getProtocol() {
        return "T=1";
    }

    @Override
    public CardChannel getBasicChannel() {
        return channel;
    }

    @Override
    public CardChannel openLogicalChannel() throws CardException {
        return channel;
    }

    @Override
    public void beginExclusive() throws CardException {
        //
    }

    @Override
    public void endExclusive() throws CardException {
        //
    }

    @Override
    public byte[] transmitControlCommand(int i, byte[] abyte0) throws CardException {
        return null;
    }

    @Override
    public void disconnect(boolean flag) throws CardException {
        //
    }

}
