/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.wsconsent.builders;

import be.ehealth.businessconnector.wsconsent.builders.RequestObjectBuilderFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.businessconnector.wsconsent.exception.WsConsentBusinessConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.hubservices.core.v2.AuthorWithPatientAndPersonType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * AuthorBuilderImplTest class test.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class AuthorBuilderImplTest {

    @BeforeClass
    public static void init() throws Exception {
        // only integration tests need to run for all professionTypes
        Assume.assumeTrue("persphysician".equals(TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.wsconsent.test.properties").getProperty("session.professionType")));
        SessionInitializer.init("/be.ehealth.businessconnector.wsconsent.test.properties", false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void testcreateAuthor() throws TechnicalConnectorException, WsConsentBusinessConnectorException, InstantiationException {

        AuthorWithPatientAndPersonType author = RequestObjectBuilderFactory.getAuthorBuilder().createAuthor();

        // NIHII
        HcpartyType hcpartyType = author.getHcparties().get(0);
        Assert.assertEquals(IDHCPARTYschemes.ID_HCPARTY, hcpartyType.getIds().get(0).getS());
        Assert.assertNotNull(hcpartyType.getIds().get(0).getValue());
        // INSS
        Assert.assertEquals(IDHCPARTYschemes.INSS, hcpartyType.getIds().get(1).getS());
        Assert.assertNotNull(hcpartyType.getIds().get(1).getValue());
        // ProfessionType
        Assert.assertEquals(CDHCPARTYschemes.CD_HCPARTY, author.getHcparties().get(0).getCds().get(0).getS());
        Assert.assertNotNull(hcpartyType.getCds().get(0).getValue());


        Assert.assertNull(author.getPatient());

        for (HcpartyType hcp : author.getHcparties()) {
            ConnectorXmlUtils.dump(hcp);
        }
    }


}
