package be.ehealth.businessconnector.test.medadmin.session;

import be.cin.mycarenet._1_0.carenet.types.MedAdminRequestList;
import be.cin.mycarenet._1_0.carenet.types.SingleNurseContractualCareRequest;
import be.cin.mycarenet._1_0.carenet.types.SinglePalliativeCareRequest;
import be.cin.mycarenet._1_0.carenet.types.SingleSpecificTechnicalCareRequest;
import be.cin.nip.async.generic.ConfirmResponse;
import be.cin.nip.async.generic.PostResponse;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.businessconnector.genericasync.domain.GetRequest;
import be.ehealth.businessconnector.genericasync.domain.ProcessedGetResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedPostResponse;
import be.ehealth.businessconnector.genericasync.domain.ProcessedTAckResponse;
import be.ehealth.businessconnector.medadmin.domain.M4AXmlProcessedGetResponse;
import be.ehealth.businessconnector.medadmin.session.MedadminSessionServiceFactory;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import java.util.List;
import java.util.concurrent.TimeUnit;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;


/**
 * @author EH071
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class MedAdminPostAsyncIntegrationTest {

    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.medadmin.test.properties").build();

    private static final int SECONDS_WAITING = 120;

    private static final String REQUEST_FOLDER = "/examples/medadmin/async/request/";


    @Test
    public void postSingleNurseContractualCareRequest_oa100() throws Exception {
        postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "100");
    }

    @Test
    public void postSingleNurseContractualCareRequest_oa300() throws Exception {
        postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "300");
    }

    @Test
    public void postSingleNurseContractualCareRequest_oa500() throws Exception {
        postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "500");
    }

    @Test
    public void postSingleNurseContractualCareRequest_oa600() throws Exception {
        postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "600");
    }

    @Test
    public void postSingleNurseContractualCareRequest_oa900() throws Exception {
        postSingleNurseContractualCareRequest("SingleNurseContractualCareRequest.xml", "900");
    }

    @Test
    public void postSinglePalliativeCareRequest_oa100() throws Exception {
        postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "100");
    }

    @Test
    public void postSinglePalliativeCareRequest_oa300() throws Exception {
        postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "300");
    }

    @Test
    public void postSinglePalliativeCareRequest_oa500() throws Exception {
        postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "500");
    }

    @Test
    public void postSinglePalliativeCareRequest_oa600() throws Exception {
        postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "600");
    }

    @Test
    public void postSinglePalliativeCareRequest_oa900() throws Exception {
        postSinglePalliativeCareRequest("SinglePalliativeCareRequest.xml", "900");
    }


    @Test
    public void postSingleSpecificTechnicalCareRequest_oa100() throws Exception {
        postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "100");
    }

    @Test
    public void postSingleSpecificTechnicalCareRequest_oa300() throws Exception {
        postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "300");
    }

    @Test
    public void postSingleSpecificTechnicalCareRequest_oa500() throws Exception {
        postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "500");
    }

    @Test
    public void postSingleSpecificTechnicalCareRequest_oa600() throws Exception {
        postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "600");
    }

    @Test
    public void postSingleSpecificTechnicalCareRequest_oa900() throws Exception {
        postSingleSpecificTechnicalCareRequest("SingleSpecificTechnicalCareRequest.xml", "900");
    }

    @Test
    public void postMedAdminRequestList_oa100() throws Exception {
        postMedAdminRequestList("MedAdminRequestList.xml", "100");
    }

    @Test
    public void postMedAdminRequestList_oa300() throws Exception {
        postMedAdminRequestList("MedAdminRequestList.xml", "300");
    }

    @Test
    public void postMedAdminRequestList_oa500() throws Exception {
        postMedAdminRequestList("MedAdminRequestList.xml", "500");
    }

    @Test
    public void postMedAdminRequestList_oa600() throws Exception {
        postMedAdminRequestList("MedAdminRequestList.xml", "600");
    }

    @Test
    public void postMedAdminRequestList_oa900() throws Exception {
        postMedAdminRequestList("MedAdminRequestList.xml", "900");
    }

    private void postMedAdminRequestList(String requestFile, String oa) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                .postMedAdminRequestList(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
                                MedAdminRequestList.class), oa, generateInputReference());
        processTack(processedPostResponse.getPostResponse());
    }

    private void postSingleSpecificTechnicalCareRequest(String requestFile, String oa) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                .postSingleSpecificTechnicalCareRequest(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
                                SingleSpecificTechnicalCareRequest.class), oa, generateInputReference());
        processTack(processedPostResponse.getPostResponse());
    }

    private void postSinglePalliativeCareRequest(String requestFile, String oa) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                .postSinglePalliativeCareRequest(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
                                SinglePalliativeCareRequest.class), oa, generateInputReference());
        processTack(processedPostResponse.getPostResponse());
    }

    private void postSingleNurseContractualCareRequest(String requestFile, String oa) throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                .postSingleNurseContractualCareRequest(ConnectorXmlUtils
                        .toObject(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + requestFile),
                                SingleNurseContractualCareRequest.class), oa, generateInputReference());
        processTack(processedPostResponse.getPostResponse());
    }

    private void processTack(PostResponse postResponse) throws InterruptedException, ConnectorException {
        String reference = postResponse.getReturn().getReference();
        waitForTack();
        M4AXmlProcessedGetResponse response = MedadminSessionServiceFactory.getMedadminService()
                .getM4AXml(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = MedadminSessionServiceFactory.getMedadminService()
                .getM4AXml(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    @Test
    public void postM4AFlat() throws ConnectorException, InterruptedException {
        ProcessedPostResponse processedPostResponse = MedadminSessionServiceFactory.getMedadminService()
                .postM4AFlat(ConnectorIOUtils.getResourceAsByteArray(REQUEST_FOLDER + "EH-420001.txt"),"600", generateInputReference());
        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
        waitForTack();
        ProcessedGetResponse<byte[]> response = MedadminSessionServiceFactory.getMedadminService()
                .getM4AFlat(GetRequest.newBuilder().withReference(reference).build());
        confirmTacks(response);
        response = MedadminSessionServiceFactory.getMedadminService()
                .getM4AFlat(GetRequest.newBuilder().withReference(reference).build());
        assertTackRemoved(response.getTAckResponses());
    }

    private void confirmTacks(ProcessedGetResponse processedGetResponse) throws ConnectorException {
        ConfirmResponse confirmResponse = MedadminSessionServiceFactory.getMedadminService().confirmAllTAcks(processedGetResponse);
        assertNotNull(confirmResponse);
    }

    public void assertTackRemoved(List<ProcessedTAckResponse> tAckResponses) {
        assertEquals("Tack should be removed", 0, tAckResponses.size());
    }

    public void waitForTack() throws InterruptedException {
        TimeUnit.SECONDS.sleep(SECONDS_WAITING);
    }

    private InputReference generateInputReference() throws TechnicalConnectorException {
        // create a reference with format yyyyMMddHHmmss
        return new InputReference();
        // or:
        // return new InputReference("your custom reference");
    }
}
