/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.domain;

import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.feature.GenericFeature;
import java.util.HashMap;
import java.util.Map;

public class FeatureLoader {
    private Map<Class, GenericFeature> activeFeatures = new HashMap<Class, GenericFeature>();

    public <T extends GenericFeature> T getFeature(Class<T> clazz) {
        for (Map.Entry<Class, GenericFeature> entry : this.activeFeatures.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            return (T)entry.getValue();
        }
        return (T)this.activeFeatures.get(clazz);
    }

    public boolean hasFeature(Class<?> clazz) {
        for (Class key : this.activeFeatures.keySet()) {
            if (!clazz.isAssignableFrom(key)) continue;
            return true;
        }
        return this.activeFeatures.containsKey(clazz);
    }

    public void register(GenericFeature ... features) {
        for (GenericFeature feature : features) {
            if (feature == null) continue;
            this.activeFeatures.put(feature.getClass(), feature);
        }
    }

    public HandlerChain getHandlerChain() {
        HandlerChain handlerChain = new HandlerChain();
        for (GenericFeature feature : this.activeFeatures.values()) {
            handlerChain.add(feature.getHandlers());
        }
        return handlerChain;
    }

    public Map<String, Object> getRequestMap() {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        for (GenericFeature feature : this.activeFeatures.values()) {
            if (feature == null) continue;
            requestMap.put(feature.getID(), feature.isEnabled());
            requestMap.putAll(feature.requestParamOptions());
        }
        return requestMap;
    }
}

