/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.validator.impl.handler;

import be.ehealth.technicalconnector.validator.impl.handler.XOPValidationHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorCollectorHandler
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorCollectorHandler.class);
    public static final String WARNING = "WARN";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    private XOPValidationHandler xopHandler;
    private List<String> exceptionWarningList = new ArrayList<String>();
    private List<String> exceptionErrorList = new ArrayList<String>();
    private List<String> exceptionFatalList = new ArrayList<String>();

    public ErrorCollectorHandler() {
    }

    public ErrorCollectorHandler(XOPValidationHandler xopHandler) {
        this.xopHandler = xopHandler;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        String msg = "WARNING " + this.toString(exception);
        this.exceptionWarningList.add(msg);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.accept(exception)) {
            String msg = "ERROR " + this.toString(exception);
            this.exceptionErrorList.add(msg);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.accept(exception)) {
            String msg = "FATAL " + this.toString(exception);
            this.exceptionFatalList.add(msg);
        }
    }

    private String toString(SAXParseException exception) {
        return exception.getMessage();
    }

    public final List<String> getExceptionList(String ... errorType) {
        ArrayList<String> exceptionList = new ArrayList<String>();
        if (ArrayUtils.contains((Object[])errorType, (Object)WARNING)) {
            exceptionList.addAll(this.exceptionWarningList);
        }
        if (ArrayUtils.contains((Object[])errorType, (Object)ERROR)) {
            exceptionList.addAll(this.exceptionErrorList);
        }
        if (ArrayUtils.contains((Object[])errorType, (Object)FATAL)) {
            exceptionList.addAll(this.exceptionFatalList);
        }
        return exceptionList;
    }

    public final boolean hasExceptions(String ... errorType) {
        if (ArrayUtils.contains((Object[])errorType, (Object)WARNING) && !this.exceptionWarningList.isEmpty()) {
            return true;
        }
        if (ArrayUtils.contains((Object[])errorType, (Object)ERROR) && !this.exceptionErrorList.isEmpty()) {
            return true;
        }
        return ArrayUtils.contains((Object[])errorType, (Object)FATAL) && !this.exceptionFatalList.isEmpty();
    }

    private boolean accept(SAXParseException ex) {
        if (this.xopHandler != null && this.xopHandler.isXop()) {
            LOG.debug("XOP element detected, skipping error [{}]", (Object)ex.getMessage());
            return false;
        }
        return true;
    }
}

