/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.AlgorithmSuiteValidator;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.DOMX509IssuerSerial;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.str.EncryptedKeySTRParser;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.util.EncryptionUtils;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.X509Util;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EncryptedKeyProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedKeyProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        return this.handleToken(elem, data, wsDocInfo, data.getAlgorithmSuite());
    }

    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo, AlgorithmSuite algorithmSuite) throws WSSecurityException {
        WSSecurityEngineResult result;
        String id;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found encrypted key element");
        }
        if (!"".equals(id = elem.getAttributeNS(null, "Id")) && (result = wsDocInfo.getResult(id)) != null && 4 == (Integer)result.get("action")) {
            return Collections.singletonList(result);
        }
        if (data.getCallbackHandler() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
        }
        String encryptedKeyTransportMethod = X509Util.getEncAlgo(elem);
        if (encryptedKeyTransportMethod == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "noEncAlgo");
        }
        if (!(!"http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encryptedKeyTransportMethod) || data.isAllowRSA15KeyTransportAlgorithm() || algorithmSuite != null && algorithmSuite.getKeyWrapAlgorithms().contains("http://www.w3.org/2001/04/xmlenc#rsa-1_5"))) {
            LOG.debug("The Key transport method does not match the requirement");
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
        }
        this.checkBSPCompliance(elem, encryptedKeyTransportMethod, data.getBSPEnforcer());
        Element xencCipherValue = EncryptionUtils.getCipherValueFromEncryptedData(elem);
        if (xencCipherValue == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noCipher");
        }
        EncryptedKeySTRParser strParser = new EncryptedKeySTRParser();
        boolean symmetricKeyWrap = EncryptedKeyProcessor.isSymmetricKeyWrap(encryptedKeyTransportMethod);
        X509Certificate[] certs = null;
        if (!symmetricKeyWrap) {
            certs = this.getCertificatesFromEncryptedKey(elem, data, wsDocInfo, strParser);
        }
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            if (!symmetricKeyWrap) {
                algorithmSuiteValidator.checkAsymmetricKeyLength(certs[0]);
            }
            algorithmSuiteValidator.checkEncryptionKeyWrapAlgorithm(encryptedKeyTransportMethod);
        }
        byte[] encryptedEphemeralKey = null;
        byte[] decryptedBytes = null;
        List<String> dataRefURIs = this.getDataRefURIs(elem);
        String xopUri = EncryptionUtils.getXOPURIFromCipherValue(xencCipherValue);
        encryptedEphemeralKey = xopUri != null && xopUri.startsWith("cid:") ? WSSecurityUtil.getBytesFromAttachment(xopUri, data) : EncryptionUtils.getDecodedBase64EncodedData(xencCipherValue);
        decryptedBytes = symmetricKeyWrap ? EncryptedKeyProcessor.getSymmetricDecryptedBytes(data, wsDocInfo, elem, dataRefURIs, encryptedEphemeralKey) : EncryptedKeyProcessor.getAsymmetricDecryptedBytes(data, wsDocInfo, encryptedKeyTransportMethod, encryptedEphemeralKey, dataRefURIs, elem, certs[0]);
        List<WSDataRef> dataRefs = this.decryptDataRefs(dataRefURIs, elem.getOwnerDocument(), wsDocInfo, decryptedBytes, data);
        WSSecurityEngineResult result2 = new WSSecurityEngineResult(4, decryptedBytes, encryptedEphemeralKey, dataRefs, certs);
        result2.put("encrypted-key-transport-method", encryptedKeyTransportMethod);
        result2.put("token-element", elem);
        String tokenId = elem.getAttributeNS(null, "Id");
        if (!"".equals(tokenId)) {
            result2.put("id", tokenId);
        }
        if (strParser != null) {
            result2.put("x509-reference-type", strParser.getCertificatesReferenceType());
        }
        wsDocInfo.addResult(result2);
        wsDocInfo.addTokenElement(elem);
        return Collections.singletonList(result2);
    }

    private static byte[] getSymmetricDecryptedBytes(RequestData data, WSDocInfo wsDocInfo, Element encryptedKeyElement, List<String> dataRefURIs, byte[] encryptedEphemeralKey) throws WSSecurityException {
        String algorithmURI = null;
        Element keyInfoChildElement = WSSecurityUtil.getDirectChildElement(encryptedKeyElement, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (!dataRefURIs.isEmpty()) {
            String uri = dataRefURIs.iterator().next();
            Element ee = EncryptionUtils.findEncryptedDataElement(encryptedKeyElement.getOwnerDocument(), wsDocInfo, uri);
            algorithmURI = X509Util.getEncAlgo(ee);
        }
        return X509Util.getSecretKey(keyInfoChildElement, algorithmURI, data.getCallbackHandler(), encryptedEphemeralKey);
    }

    private static byte[] getAsymmetricDecryptedBytes(RequestData data, WSDocInfo wsDocInfo, String encryptedKeyTransportMethod, byte[] encryptedEphemeralKey, List<String> dataRefURIs, Element encryptedKeyElement, X509Certificate cert) throws WSSecurityException {
        if (data.getDecCrypto() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noDecCryptoFile");
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(encryptedKeyTransportMethod);
        try {
            PrivateKey privateKey = data.getDecCrypto().getPrivateKey(cert, data.getCallbackHandler());
            OAEPParameterSpec oaepParameterSpec = null;
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encryptedKeyTransportMethod) || "http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptedKeyTransportMethod)) {
                String digestAlgorithm = EncryptionUtils.getDigestAlgorithm(encryptedKeyElement);
                String jceDigestAlgorithm = "SHA-1";
                if (digestAlgorithm != null && !"".equals(digestAlgorithm)) {
                    jceDigestAlgorithm = JCEMapper.translateURItoJCEID((String)digestAlgorithm);
                }
                MGF1ParameterSpec mgfParameterSpec = new MGF1ParameterSpec("SHA-1");
                if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptedKeyTransportMethod)) {
                    String mgfAlgorithm = EncryptionUtils.getMGFAlgorithm(encryptedKeyElement);
                    if ("http://www.w3.org/2009/xmlenc11#mgf1sha224".equals(mgfAlgorithm)) {
                        mgfParameterSpec = new MGF1ParameterSpec("SHA-224");
                    } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha256".equals(mgfAlgorithm)) {
                        mgfParameterSpec = new MGF1ParameterSpec("SHA-256");
                    } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha384".equals(mgfAlgorithm)) {
                        mgfParameterSpec = new MGF1ParameterSpec("SHA-384");
                    } else if ("http://www.w3.org/2009/xmlenc11#mgf1sha512".equals(mgfAlgorithm)) {
                        mgfParameterSpec = new MGF1ParameterSpec("SHA-512");
                    }
                }
                PSource.PSpecified pSource = PSource.PSpecified.DEFAULT;
                byte[] pSourceBytes = EncryptionUtils.getPSource(encryptedKeyElement);
                if (pSourceBytes != null) {
                    pSource = new PSource.PSpecified(pSourceBytes);
                }
                oaepParameterSpec = new OAEPParameterSpec(jceDigestAlgorithm, "MGF1", mgfParameterSpec, pSource);
            }
            if (oaepParameterSpec == null) {
                cipher.init(4, privateKey);
            } else {
                cipher.init(4, (Key)privateKey, oaepParameterSpec);
            }
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, ex);
        }
        try {
            String keyAlgorithm = JCEMapper.translateURItoJCEID((String)encryptedKeyTransportMethod);
            return cipher.unwrap(encryptedEphemeralKey, keyAlgorithm, 3).getEncoded();
        }
        catch (IllegalStateException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)ex);
        }
        catch (Exception ex) {
            return EncryptedKeyProcessor.getRandomKey(dataRefURIs, encryptedKeyElement.getOwnerDocument(), wsDocInfo);
        }
    }

    private static boolean isSymmetricKeyWrap(String transportAlgorithm) {
        return "http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmldsig-more#kw-camellia128".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmldsig-more#kw-camellia192".equals(transportAlgorithm) || "http://www.w3.org/2001/04/xmldsig-more#kw-camellia256".equals(transportAlgorithm) || "http://www.w3.org/2007/05/xmldsig-more#kw-seed128".equals(transportAlgorithm);
    }

    private static byte[] getRandomKey(List<String> dataRefURIs, Document doc, WSDocInfo wsDocInfo) throws WSSecurityException {
        try {
            String alg = "AES";
            int size = 16;
            if (!dataRefURIs.isEmpty()) {
                String uri = dataRefURIs.iterator().next();
                Element ee = EncryptionUtils.findEncryptedDataElement(doc, wsDocInfo, uri);
                String algorithmURI = X509Util.getEncAlgo(ee);
                alg = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                size = KeyUtils.getKeyLength((String)algorithmURI);
            }
            KeyGenerator kgen = KeyGenerator.getInstance(alg);
            kgen.init(size * 8);
            SecretKey k = kgen.generateKey();
            return k.getEncoded();
        }
        catch (Throwable ex) {
            try {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey k = kgen.generateKey();
                return k.getEncoded();
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
            }
        }
    }

    private X509Certificate[] getCertificatesFromEncryptedKey(Element xencEncryptedKey, RequestData data, WSDocInfo wsDocInfo, STRParser strParser) throws WSSecurityException {
        Element keyInfo = WSSecurityUtil.getDirectChildElement(xencEncryptedKey, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfo != null) {
            Element strElement = null;
            int result = 0;
            for (Node node = keyInfo.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                ++result;
                strElement = (Element)node;
            }
            if (result != 1) {
                data.getBSPEnforcer().handleBSPRule(BSPRule.R5424);
            }
            if (strElement == null || strParser == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noSecTokRef");
            }
            X509Certificate[] certs = null;
            if ("SecurityTokenReference".equals(strElement.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(strElement.getNamespaceURI())) {
                strParser.parseSecurityTokenReference(strElement, data, wsDocInfo, null);
                certs = strParser.getCertificates();
            } else if ("http://www.w3.org/2000/09/xmldsig#".equals(strElement.getNamespaceURI()) && "X509Data".equals(strElement.getLocalName())) {
                data.getBSPEnforcer().handleBSPRule(BSPRule.R5426);
                Element x509Child = this.getFirstElement(strElement);
                if (x509Child != null && "http://www.w3.org/2000/09/xmldsig#".equals(x509Child.getNamespaceURI())) {
                    if ("X509IssuerSerial".equals(x509Child.getLocalName())) {
                        DOMX509IssuerSerial issuerSerial = new DOMX509IssuerSerial(x509Child);
                        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ISSUER_SERIAL);
                        cryptoType.setIssuerSerial(issuerSerial.getIssuer(), issuerSerial.getSerialNumber());
                        certs = data.getDecCrypto().getX509Certificates(cryptoType);
                    } else if ("X509Certificate".equals(x509Child.getLocalName())) {
                        byte[] token = this.getToken(x509Child);
                        if (token == null) {
                            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidCertData", new Object[]{"0"});
                        }
                        ByteArrayInputStream in = new ByteArrayInputStream(token);
                        X509Certificate cert = data.getDecCrypto().loadCertificate((InputStream)in);
                        if (cert != null) {
                            certs = new X509Certificate[]{cert};
                        }
                    }
                }
            }
            if (certs == null || certs.length < 1 || certs[0] == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCertsFound", new Object[]{"decryption (KeyId)"});
            }
            return certs;
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "noKeyinfo");
    }

    private Element getFirstElement(Element element) {
        for (Node currentChild = element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType()) continue;
            return (Element)currentChild;
        }
        return null;
    }

    private byte[] getToken(Element element) {
        StringBuilder builder = new StringBuilder();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (3 != node.getNodeType()) continue;
            builder.append(((Text)node).getData());
        }
        try {
            return Base64.decode((String)builder.toString());
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    private List<String> getDataRefURIs(Element xencEncryptedKey) {
        Element refList = WSSecurityUtil.getDirectChildElement(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        LinkedList<String> dataRefURIs = new LinkedList<String>();
        if (refList != null) {
            for (Node node = refList.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType() || !"http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || !"DataReference".equals(node.getLocalName())) continue;
                String dataRefURI = ((Element)node).getAttributeNS(null, "URI");
                if (dataRefURI.charAt(0) == '#') {
                    dataRefURI = dataRefURI.substring(1);
                }
                dataRefURIs.add(dataRefURI);
            }
        }
        return dataRefURIs;
    }

    private List<WSDataRef> decryptDataRefs(List<String> dataRefURIs, Document doc, WSDocInfo docInfo, byte[] decryptedBytes, RequestData data) throws WSSecurityException {
        if (dataRefURIs == null || dataRefURIs.isEmpty()) {
            return null;
        }
        ArrayList<WSDataRef> dataRefs = new ArrayList<WSDataRef>();
        for (String dataRefURI : dataRefURIs) {
            WSDataRef dataRef = this.decryptDataRef(doc, dataRefURI, docInfo, decryptedBytes, data);
            dataRefs.add(dataRef);
        }
        return dataRefs;
    }

    private WSDataRef decryptDataRef(Document doc, String dataRefURI, WSDocInfo docInfo, byte[] decryptedData, RequestData data) throws WSSecurityException {
        String symEncAlgo;
        Element encryptedDataElement;
        if (LOG.isDebugEnabled()) {
            LOG.debug("found data reference: " + dataRefURI);
        }
        if ((encryptedDataElement = EncryptionUtils.findEncryptedDataElement(doc, docInfo, dataRefURI)) != null && data.isRequireSignedEncryptedDataElements()) {
            List<WSSecurityEngineResult> signedResults = docInfo.getResultsByTag(2);
            WSSecurityUtil.verifySignedElement(encryptedDataElement, signedResults);
        }
        if ((symEncAlgo = X509Util.getEncAlgo(encryptedDataElement)) == null) {
            LOG.debug("No encryption algorithm was specified in the request");
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "badEncAlgo", new Object[]{null});
        }
        if (!("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(symEncAlgo) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(symEncAlgo) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(symEncAlgo) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(symEncAlgo) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(symEncAlgo))) {
            data.getBSPEnforcer().handleBSPRule(BSPRule.R5620);
        }
        SecretKey symmetricKey = null;
        try {
            symmetricKey = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])decryptedData);
        }
        catch (IllegalArgumentException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)ex, "badEncAlgo", new Object[]{symEncAlgo});
        }
        AlgorithmSuite algorithmSuite = data.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            algorithmSuiteValidator.checkSymmetricKeyLength(symmetricKey.getEncoded().length);
            algorithmSuiteValidator.checkSymmetricEncryptionAlgorithm(symEncAlgo);
        }
        return EncryptionUtils.decryptEncryptedData(doc, dataRefURI, encryptedDataElement, symmetricKey, symEncAlgo, data);
    }

    private void checkBSPCompliance(Element elem, String encAlgo, BSPEnforcer bspEnforcer) throws WSSecurityException {
        String attribute = elem.getAttributeNS(null, "Type");
        if (attribute != null && !"".equals(attribute)) {
            bspEnforcer.handleBSPRule(BSPRule.R3209);
        }
        if ((attribute = elem.getAttributeNS(null, "MimeType")) != null && !"".equals(attribute)) {
            bspEnforcer.handleBSPRule(BSPRule.R5622);
        }
        if ((attribute = elem.getAttributeNS(null, "Encoding")) != null && !"".equals(attribute)) {
            bspEnforcer.handleBSPRule(BSPRule.R5623);
        }
        if ((attribute = elem.getAttributeNS(null, "Recipient")) != null && !"".equals(attribute)) {
            bspEnforcer.handleBSPRule(BSPRule.R5602);
        }
        if (!("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encAlgo))) {
            bspEnforcer.handleBSPRule(BSPRule.R5621);
        }
    }
}

