/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.schematron.utils;

import be.fgov.ehealth.schematron.utils.LogicalPhysicalMap;
import be.fgov.ehealth.schematron.utils.NamespacePrefixMappings;
import be.fgov.ehealth.schematron.utils.PhysicalLocation;
import be.fgov.ehealth.schematron.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SvrlHarvestHandler
implements ContentHandler {
    static Logger LOG = LoggerFactory.getLogger(SvrlHarvestHandler.class);
    private NamespacePrefixMappings nsMap;
    private LogicalPhysicalMap locMap;

    public SvrlHarvestHandler(LogicalPhysicalMap locMap, NamespacePrefixMappings nsMap) {
        this.nsMap = nsMap;
        this.locMap = locMap;
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        LOG.debug("SVRL harvest done; xpath count:" + this.locMap.size());
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        LOG.debug("Beginning SVRL harvest");
    }

    @Override
    public void startElement(String uri, String localName, String arqName, Attributes atts) throws SAXException {
        if (uri.equals("http://purl.oclc.org/dsdl/svrl")) {
            if (localName.equals("successful-report") || localName.equals("failed-assert")) {
                String xpath = atts.getValue("location");
                if (this.locMap.get(xpath) == null) {
                    xpath = Utils.trimAttributePart(xpath);
                    this.locMap.put(xpath, new PhysicalLocation());
                }
            } else if (localName.equals("ns-prefix-in-attribute-values")) {
                String prefix = atts.getValue("prefix");
                String ns = atts.getValue("uri");
                this.nsMap.registerMapping(prefix, ns);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String url) throws SAXException {
    }
}

