/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.consumer.tlv;

import be.fedict.commons.eid.consumer.tlv.ConvertData;
import be.fedict.commons.eid.consumer.tlv.DataConvertor;
import be.fedict.commons.eid.consumer.tlv.DataConvertorException;
import be.fedict.commons.eid.consumer.tlv.OriginalData;
import be.fedict.commons.eid.consumer.tlv.TlvField;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TlvParser {
    private static final Log LOG = LogFactory.getLog(TlvParser.class);

    private TlvParser() {
    }

    public static <T> T parse(byte[] file, Class<T> tlvClass) {
        T t;
        try {
            t = TlvParser.parseThrowing(file, tlvClass);
        }
        catch (Exception ex) {
            throw new RuntimeException("error parsing file: " + tlvClass.getName(), ex);
        }
        return t;
    }

    private static byte[] copy(byte[] source, int idx, int count) {
        byte[] result = new byte[count];
        System.arraycopy(source, idx, result, 0, count);
        return result;
    }

    private static <T> T parseThrowing(byte[] file, Class<T> tlvClass) throws InstantiationException, IllegalAccessException, DataConvertorException, UnsupportedEncodingException {
        Field[] fields = tlvClass.getDeclaredFields();
        HashMap<Integer, Field> tlvFields = new HashMap<Integer, Field>();
        T tlvObject = tlvClass.newInstance();
        for (Field field : fields) {
            OriginalData originalDataAnnotation;
            TlvField tlvFieldAnnotation = field.getAnnotation(TlvField.class);
            if (null != tlvFieldAnnotation) {
                int tagId = tlvFieldAnnotation.value();
                if (tlvFields.containsKey(new Integer(tagId))) {
                    throw new IllegalArgumentException("TLV field duplicate: " + tagId);
                }
                tlvFields.put(new Integer(tagId), field);
            }
            if (null == (originalDataAnnotation = field.getAnnotation(OriginalData.class))) continue;
            field.setAccessible(true);
            field.set(tlvObject, file);
        }
        int idx = 0;
        while (idx < file.length - 1) {
            byte tag = file[idx];
            byte lengthByte = file[++idx];
            int length = lengthByte & 0x7F;
            while ((lengthByte & 0x80) == 128) {
                lengthByte = file[++idx];
                length = (length << 7) + (lengthByte & 0x7F);
            }
            ++idx;
            if (0 == tag) {
                idx += length;
                continue;
            }
            if (tlvFields.containsKey(new Integer(tag))) {
                Object fieldValue;
                Field tlvField = (Field)tlvFields.get(new Integer(tag));
                Class<?> tlvType = tlvField.getType();
                ConvertData convertDataAnnotation = tlvField.getAnnotation(ConvertData.class);
                byte[] tlvValue = TlvParser.copy(file, idx, length);
                if (null != convertDataAnnotation) {
                    Class<DataConvertor<?>> dataConvertorClass = convertDataAnnotation.value();
                    DataConvertor<?> dataConvertor = dataConvertorClass.newInstance();
                    fieldValue = dataConvertor.convert(tlvValue);
                } else if (String.class == tlvType) {
                    fieldValue = new String(tlvValue, "UTF-8");
                } else if (Boolean.TYPE == tlvType) {
                    fieldValue = true;
                } else if (tlvType.isArray() && Byte.TYPE == tlvType.getComponentType()) {
                    fieldValue = tlvValue;
                } else {
                    throw new IllegalArgumentException("unsupported field type: " + tlvType.getName());
                }
                if (null != tlvField.get(tlvObject) && !tlvField.getType().isPrimitive()) {
                    throw new RuntimeException("field was already set: " + tlvField.getName());
                }
                tlvField.setAccessible(true);
                tlvField.set(tlvObject, fieldValue);
            } else {
                LOG.debug((Object)("unknown tag: " + (tag & 0xFF) + ", length: " + length));
            }
            idx += length;
        }
        return tlvObject;
    }
}

