/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

public final class DateUtils {
    private DateUtils() {
        throw new UnsupportedOperationException();
    }

    public static DateTime parseDateTime(String lexicalXSDDate) {
        if (lexicalXSDDate == null || lexicalXSDDate.isEmpty()) {
            return null;
        }
        return DateUtils.convert(DatatypeConverter.parseDateTime((String)lexicalXSDDate));
    }

    public static String printDateTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DatatypeConverter.printDateTime((Calendar)DateUtils.convert(dateTime));
    }

    public static DateTime parseTime(String lexicalXSDDate) {
        if (lexicalXSDDate == null || lexicalXSDDate.isEmpty()) {
            return null;
        }
        return DateUtils.convert(DatatypeConverter.parseTime((String)lexicalXSDDate));
    }

    public static String printTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DatatypeConverter.printTime((Calendar)DateUtils.convert(dateTime));
    }

    public static String printTimeWithoutTimezone(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeFormat.forPattern((String)"HH:mm:ss").print((ReadableInstant)dateTime);
    }

    public static DateTime parseDate(String lexicalXSDDate) {
        if (lexicalXSDDate == null || lexicalXSDDate.isEmpty()) {
            return null;
        }
        return DateUtils.convert(DatatypeConverter.parseDate((String)lexicalXSDDate));
    }

    public static String printDate(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DatatypeConverter.printDate((Calendar)DateUtils.convert(dateTime));
    }

    public static String printDateWithoutTimeZone(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return ISODateTimeFormat.date().print((ReadableInstant)dateTime);
    }

    public static DateTime convert(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return new DateTime((Object)cal);
    }

    public static DateTime convert(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date);
    }

    private static Calendar convert(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toCalendar(Locale.getDefault());
    }
}

