/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetdomaincommons.mapper;

import be.cin.types.v1.Blob;
import be.cin.types.v1.ContentEncryptionType;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ByteArrayDatasource;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.io.IOUtils;
import org.w3._2005._05.xmlmime.Base64Binary;

public final class DomainBlobMapper {
    public static be.ehealth.business.mycarenetdomaincommons.domain.Blob mapToBlob(Blob blob) throws TechnicalConnectorException {
        be.ehealth.business.mycarenetdomaincommons.domain.Blob result = new be.ehealth.business.mycarenetdomaincommons.domain.Blob();
        result.setContent(DomainBlobMapper.convertToByteArray(blob.getValue()));
        result.setId(blob.getId());
        result.setContentEncoding(blob.getContentEncoding());
        result.setHashValue(blob.getHashValue());
        result.setContentType(blob.getContentType());
        return result;
    }

    public static Blob mapBlobToCinBlob(be.ehealth.business.mycarenetdomaincommons.domain.Blob blob) {
        Blob result = new Blob();
        ByteArrayDatasource rawData = new ByteArrayDatasource(blob.getContent());
        DataHandler dh = new DataHandler((DataSource)rawData);
        result.setValue(dh);
        result.setMessageName(blob.getMessageName());
        result.setId(blob.getId());
        result.setContentEncoding(blob.getContentEncoding());
        result.setHashValue(blob.getHashValue());
        result.setContentType(blob.getContentType());
        result.setContentEncryption(blob.getContentEncryption() == null ? null : ContentEncryptionType.fromValue((String)blob.getContentEncryption()));
        return result;
    }

    public static Base64Binary mapB64fromByte(byte[] param) {
        Base64Binary result = new Base64Binary();
        result.setValue(param);
        result.setContentType("text/xml");
        return result;
    }

    private static byte[] convertToByteArray(DataHandler value) throws TechnicalConnectorException {
        if (value == null) {
            return new byte[0];
        }
        try {
            return IOUtils.toByteArray((InputStream)value.getInputStream());
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNKNOWN_ERROR, new Object[]{"IoException while converting dataHandler to byteArray", e});
        }
    }
}

