/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.model.PortBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortBindingSerializer
implements Serializer<PortBinding> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    @Override
    public String serialize(PortBinding portBinding) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)portBinding);
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception while serializing portBinding to JSON with value %s", portBinding), (Throwable)e);
            throw new RuntimeException(String.format("Exception while serializing portBinding to JSON with value %s", portBinding), e);
        }
    }

    @Override
    public PortBinding deserialize(String jsonPortBinding) {
        PortBinding portBinding = null;
        if (jsonPortBinding != null && !jsonPortBinding.isEmpty()) {
            try {
                portBinding = (PortBinding)this.objectMapper.readValue(jsonPortBinding, PortBinding.class);
            }
            catch (Exception e) {
                this.logger.info("Exception while parsing PortBinding for [" + jsonPortBinding + "]", (Throwable)e);
                throw new RuntimeException("Exception while parsing PortBinding for [" + jsonPortBinding + "]", e);
            }
        }
        return portBinding;
    }

    @Override
    public Class<PortBinding> supportsType() {
        return PortBinding.class;
    }
}

