﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.addressbook.core.v1;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using ikvm.extensions;
using NUnit.Framework;
using java.math;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.addressbook.protocol.v1;
using be.fgov.ehealth.technicalconnector.tests.junit.rule;
using be.ehealth.businessconnector.addressbook.integration;

namespace be.ehealth.businessconnector.addressbook.session
{
	/**
	 * Addressbook Service Integration Tests This test shows the use of the addresbook Service through the use of the Business Connector.
	 * 
	 * All Tests require the following pre-requisites to be met: - An active and valid eHealth-platform session (initiated via the Session
	 * Management component), in these tests this is done in the AbstractServiceTest class
	 */
	[TestFixture]
	public class AddressbookSessionServiceIntegrationTest
	{
		[SetUp]
		public static void init() {
			//SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();
			java.util.Properties props = new java.util.Properties();			
        	props.put("session.environment", "acc");
        	props.put("session.professionType", "persphysician");
        	props.put("session.username", "hannes");
			SessionInitializer.init(props, true, SupportedLanguages.NET.getAbbreviation());
		}
		   
   [Test]
    public void getOrganizationContactInfoTest()  {
        GetOrganizationContactInfoRequest request = AddressbookTestUtils.createGetOrganizationContactInfoRequest();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        GetOrganizationContactInfoResponse response = service.getOrganizationContactInfo(request);
        AddressbookTestUtils.verifyResponseGetOrganizationContactInfo(response);
    }

    [Test]
    public void getProfessionalContactInfoTest()  {
        GetProfessionalContactInfoRequest request = AddressbookTestUtils.createGetProfessionalContactInfo();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        GetProfessionalContactInfoResponse response = service.getProfessionalContactInfo(request);
        AddressbookTestUtils.verifyResponseGetProfessionalContactInfo(response);
    }

    [Test]
    public void searchOrganizationsTest()  {
        SearchOrganizationsRequest request = AddressbookTestUtils.createSearchOrganizationsRequest();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        SearchOrganizationsResponse response = service.searchOrganizations(request);
        AddressbookTestUtils.verifySearchOrganizationsResponse(response);
    }

    [Test]
    public void searchProfessionalsTest()  {
        SearchProfessionalsRequest request = AddressbookTestUtils.createSearchProfessionalsRequest();

        AddressbookSessionService service = AddressbookSessionServiceFactory.getAddressbookSessionService();

        SearchProfessionalsResponse response = service.searchProfessionals(request);
        AddressbookTestUtils.verifySearchProfessionalsResponse(response);
    }
}
}