﻿﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.business.kmehrcommons;
using NUnit.Framework;
using java.util;
using be.ehealth.business.common.domain;
using be.ehealth.businessconnector.therlink.builders;
using be.ehealth.businessconnector.therlink.domain;
using be.ehealth.businessconnector.therlink.domain.requests;
using be.ehealth.businessconnector.therlink.util;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.therlink.builders.impl
{
	
	/**
	 * Integration test for {@link GPRequestObjectBuilderImpl}
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class RequestBuilderIntegrationTest
	{
		
		private static String linkType;

		[SetUp]
		public static void init() {			
            AssumeTools.isEIDEnabled();
			SessionInitializer.init("be.ehealth.businessconnector.therlink.test.properties", SupportedLanguages.NET.getAbbreviation());
			linkType = TherapeuticLinkTypeValues.valueOf(ConfigFactory.getConfigValidator().getProperty("main.kmehr.quality").ToUpper()).getTherlinkType();
		}

		[TearDown]
		public static void tearDown() {
			Session.getInstance().unloadSession();
		}

		[Test]
		public void createPutTherapeuticLinkRequestGPDefaultValues() {
			CommonObjectBuilder commonBuilder = RequestObjectBuilderFactory.getCommonBuilder();
			ProofBuilder proofBuilder = RequestObjectBuilderFactory.getProofBuilder();
			RequestObjectBuilder requestObjectBuilder = RequestObjectBuilderFactory.getRequestObjectBuilder();

			be.ehealth.business.common.domain.Patient patientMapped = TherlinkTestUtils.getOfflinePatient();
			Date startDate = new Date();
			java.util.List authorHcParties = requestObjectBuilder.getAuthorHcParties();

			TherapeuticLink createTherapeuticLink = commonBuilder.createTherapeuticLink(patientMapped, HcPartyUtil.getAuthorKmehrQuality(), linkType, startDate, new org.joda.time.DateTime().plusMonths(6).toDate(), null, ConfigReader.getCareProvider());

			PutTherapeuticLinkRequest request = new PutTherapeuticLinkRequest(commonBuilder.createKmehrID(), startDate, commonBuilder.createAuthor(authorHcParties), createTherapeuticLink, proofBuilder.createProofForEidReading());

			Assert.IsNotNull(request);
			HcParty hcp = ConfigReader.getCareProvider();

			Assert.AreEqual(patientMapped, request.getLink().getPatient());
			HcParty hcParty = request.getLink().getHcParty();
			Assert.AreEqual(hcp.getIds().size(), hcParty.getIds().size());
			Assert.AreEqual(hcp.getFirstName(), hcParty.getFirstName());
			Assert.AreEqual(hcp.getFamilyName(), hcParty.getFamilyName());
			Assert.AreEqual(linkType, request.getLink().getType());
		}
	}
}
