/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.tsl.signature;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrustServiceStatusListSignatureVerifier {
    public static final String PROP_TSL_STOREPWD = "be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.pwd";
    public static final String PROP_TSL_STORELOCATION = "be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.location";
    public static final String PROP_TSL_STORETYPE = "be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.type";
    private static final Logger LOG = LoggerFactory.getLogger(TrustServiceStatusListSignatureVerifier.class);
    private static CertStore tsloStore;
    private static final String OID_TSL_SIGNING = "0.4.0.2231.3.0";

    private TrustServiceStatusListSignatureVerifier() {
        throw new UnsupportedOperationException();
    }

    public static boolean isValid(String xml) {
        try {
            HashMap options = new HashMap();
            SignatureVerificationResult signatureResult = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES).verify(xml.getBytes("UTF-8"), options);
            if (!signatureResult.isValid()) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_SIGNATURE_VALIDATION, new Object[]{ArrayUtils.toString((Object)signatureResult.getErrors().toArray())});
            }
            X509Certificate cert = signatureResult.getSigningCert();
            if (cert.getExtendedKeyUsage().contains(OID_TSL_SIGNING)) {
                LOG.debug("ExtendedKeyUsage correct. OID 0.4.0.2231.3.0 found.");
                TrustServiceStatusListSignatureVerifier.dumpTsloStore();
                return TrustServiceStatusListSignatureVerifier.match(TrustServiceStatusListSignatureVerifier.baseOnCert(cert)) || TrustServiceStatusListSignatureVerifier.match(TrustServiceStatusListSignatureVerifier.basedOnPublicKey(cert));
            }
        }
        catch (Exception e) {
            LOG.error("Unable to verify signature Reason:" + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static void dumpTsloStore() {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Content of TSLO store");
                Collection<? extends Certificate> tsloCerts = tsloStore.getCertificates(new X509CertSelector());
                for (Certificate certificate : tsloCerts) {
                    X509Certificate x509 = (X509Certificate)certificate;
                    LOG.debug(" - " + x509.getSubjectX500Principal().getName("RFC1779"));
                }
            }
            catch (Exception e) {
                LOG.debug("Unable to print content of TSLO Store", (Throwable)e);
            }
        }
    }

    private static boolean match(X509CertSelector selector) throws TechnicalConnectorException {
        try {
            return !tsloStore.getCertificates(selector).isEmpty();
        }
        catch (CertStoreException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{"Unable to select certificates."});
        }
    }

    private static X509CertSelector baseOnCert(X509Certificate cert) {
        LOG.debug("Matching based on cert [" + cert.getSubjectX500Principal().getName("RFC1779") + "]");
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        return selector;
    }

    private static X509CertSelector basedOnPublicKey(X509Certificate cert) {
        LOG.debug("Matching based on PublicKey [" + cert.getSubjectX500Principal().getName("RFC1779") + "]");
        X509CertSelector selector = new X509CertSelector();
        selector.setSubjectPublicKey(cert.getPublicKey());
        return selector;
    }

    private static CertStore getCertStore() throws Exception {
        ArrayList<X509Certificate> certsAndCrls = new ArrayList<X509Certificate>();
        try {
            KeyStore tslStore = KeyStore.getInstance(ConfigFactory.getConfigValidator().getProperty(PROP_TSL_STORETYPE, "JKS"));
            tslStore.load(ConnectorIOUtils.getResourceAsStream((String)ConfigFactory.getConfigValidator().getProperty(PROP_TSL_STORELOCATION)), ConfigFactory.getConfigValidator().getProperty(PROP_TSL_STOREPWD, "").toCharArray());
            Enumeration<String> aliases = tslStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)tslStore.getCertificate(alias);
                LOG.debug("Adding " + cert.getSubjectX500Principal().getName("RFC1779"));
                certsAndCrls.add(cert);
            }
        }
        catch (Exception e) {
            LOG.error("Error while loading keystore", (Throwable)e);
        }
        return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certsAndCrls));
    }

    public static void reloadCertStore() {
        try {
            tsloStore = TrustServiceStatusListSignatureVerifier.getCertStore();
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    static {
        TrustServiceStatusListSignatureVerifier.reloadCertStore();
    }
}

