/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.validator.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.ehealth.technicalconnector.utils.KeyStoreManager;
import be.ehealth.technicalconnector.validator.TimeStampValidator;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public final class TimeStampValidatorFactory {
    private static final String TIMESTAMP_SIGNATURE_KEYSTORE_PWD = "timestamp.signature.keystore.pwd";
    private static final String TIMESTAMP_SIGNATURE_KEYSTORE_PATH = "timestamp.signature.keystore.path";
    private static final String PROP_KEYSTORE_DIR = "KEYSTORE_DIR";
    private static final String PROP_TIMESTAMPVALIDATOR_FACTORY = "timestamp.validator.factory";
    private static final String PROP_DEFAULT_TIMESTAMPVALIDATOR_FACTORY = "be.ehealth.technicalconnector.validator.impl.TimeStampValidatorImpl";
    private static TimeStampValidator validatorInstance;
    private static ConfigurableFactoryHelper<TimeStampValidator> helperFactory;

    private TimeStampValidatorFactory() {
        throw new UnsupportedOperationException();
    }

    public static TimeStampValidator getInstance() throws TechnicalConnectorException {
        if (validatorInstance == null) {
            validatorInstance = helperFactory.getImplementation(TimeStampValidatorFactory.init(), false);
        }
        return validatorInstance;
    }

    private static Map<String, Object> init() throws TechnicalConnectorException {
        ConfigValidator config = ConfigFactory.getConfigValidatorFor(TIMESTAMP_SIGNATURE_KEYSTORE_PATH, TIMESTAMP_SIGNATURE_KEYSTORE_PWD, PROP_KEYSTORE_DIR);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        String keystorePath = config.getProperty(PROP_KEYSTORE_DIR) + config.getProperty(TIMESTAMP_SIGNATURE_KEYSTORE_PATH);
        KeyStoreManager keyStoreManager = new KeyStoreManager(keystorePath, config.getProperty(TIMESTAMP_SIGNATURE_KEYSTORE_PWD).toCharArray());
        KeyStore keyStore = keyStoreManager.getKeyStore();
        parameterMap.put("timestampvalidatior.keystore", keyStore);
        return parameterMap;
    }

    @Deprecated
    public static TimeStampValidator getTimeStampValidator() throws TechnicalConnectorException {
        return TimeStampValidatorFactory.getInstance();
    }

    public static void reset() {
        validatorInstance = null;
    }

    static {
        helperFactory = new ConfigurableFactoryHelper(PROP_TIMESTAMPVALIDATOR_FACTORY, PROP_DEFAULT_TIMESTAMPVALIDATOR_FACTORY);
    }
}

