#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * IntegrationTest for IDSupport
 */
namespace be.ehealth.technicalconnector.service.idsupport
{
    using System;

    using be.ehealth.technicalconnector.service.idsupport.impl;
    using be.fgov.ehealth.commons.core.v2;
    using be.fgov.ehealth.idsupport.core.v2;
    using be.fgov.ehealth.idsupport.protocol.v2;

    using NUnit.Framework;

    [TestFixture]
    public class IdSupportServiceIntegrationTest : be.ehealth.technicalconnector.session.AbstractServiceIntegrationTest
    {
        #region Fields

        private static String barcode;
        private static String cardNumber;
        private static String LEGAL_CONTEXT = "patient insurance validation";
        private static String REQUEST_ID = "ID_1990000332.20131218093047194";
        private static String ssin;
        private static String SUCCESS = "urn:be:fgov:ehealth:2.0:status:Success";
        private static String URN_BARCODED = "urn:be:fgov:person:cardsupport:barcoded";
        private static String URN_CARD_NUMBER = "urn:be:fgov:person:cardsupport:cardnumber";
        private static String URN_SSIN = "urn:be:fgov:person:ssin";

        private IdSupportService service = ServiceFactory.getIdSupportService();

        #endregion Fields

        #region Methods

        [SetUpAttribute]
        public static void initConfig()
        {
            ssin = getSessionProps().getProperty("test.idsupport.ssin");
            Assert.NotNull(ssin);

            cardNumber = getSessionProps().getProperty("test.idsupport.cardnumber");
            Assert.NotNull(cardNumber);

            barcode = getSessionProps().getProperty("test.idsupport.barcode");
            Assert.NotNull(barcode);
        }

        [Test]
        public void happyPath()
        {
            VerifyIdResponse response = service.verifyId(getRequestWithSsinAndCardNumber(ssin, cardNumber));

            Assert.AreEqual(SUCCESS, response.getStatus().getStatusCode().getValue());
        }

        [Test]
        public void happyPathWithBarcode()
        {
            VerifyIdResponse response = service.verifyId(LEGAL_CONTEXT, id(URN_BARCODED, barcode));

            Assert.AreEqual(SUCCESS, response.getStatus().getStatusCode().getValue());
        }

        [Test]
        public void happyPathWithSsinAndCardNumber()
        {
            VerifyIdResponse response = service.verifyId(LEGAL_CONTEXT, id(URN_SSIN, ssin), id(URN_CARD_NUMBER, cardNumber));

            Assert.AreEqual(SUCCESS, response.getStatus().getStatusCode().getValue());
        }

        [Test]
        [ExpectedException( typeof( be.ehealth.technicalconnector.exception.SoaErrorException ) )]
        public void verifyIdWithValidationFailure()
        {
            VerifyIdResponse response = service.verifyId(getRequestWithBarcode(""));
            Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Requester", response.getStatus().getStatusCode().getValue());
            Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:InvalidInput", response.getStatus().getStatusCode().getStatusCode().getValue());
        }

        private static VerifyIdRequest getBasicRequest(String legalContext, String id)
        {
            VerifyIdRequest request = new VerifyIdRequest();

            request.setId(id);
            request.setLegalContext(legalContext);
            request.setIssueInstant(new org.joda.time.DateTime());

            return request;
        }

        // Private helpers
        private static VerifyIdRequest getRequestWithBarcode(String barcode)
        {
            VerifyIdRequest request = getBasicRequest(LEGAL_CONTEXT, REQUEST_ID);
            request.setIdentificationData(identificationData(id(URN_BARCODED, barcode)));

            return request;
        }

        private static VerifyIdRequest getRequestWithSsinAndCardNumber(String ssin, String cardNumber)
        {
            VerifyIdRequest request = getBasicRequest(LEGAL_CONTEXT, REQUEST_ID);
            request.setIdentificationData(identificationData(id(URN_SSIN, ssin), id(URN_CARD_NUMBER, cardNumber)));
            return request;
        }

        private static Id id(String type, String value)
        {
            Id id = new Id();
            id.setType(type);
            id.setValue(value);

            return id;
        }

        private static IdentificationData identificationData(params Id[] ids)
        {
            IdentificationData identificationData = new IdentificationData();
            identificationData.getIds().addAll(java.util.Arrays.asList(ids));
            return identificationData;
        }

        #endregion Methods
    }
}