/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.mockserver.echo.http.EchoServerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServer {
    private NioEventLoopGroup eventLoopGroup;

    public EchoServer(int port, boolean secure) {
        this(port, secure, null);
    }

    public EchoServer(final int port, final boolean secure, final Error error) {
        Logger logger = LoggerFactory.getLogger(EchoServer.class);
        final SettableFuture hasStarted = SettableFuture.create();
        new Thread(new Runnable(){

            @Override
            public void run() {
                EchoServer.this.eventLoopGroup = new NioEventLoopGroup();
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                NioEventLoopGroup workerGroup = new NioEventLoopGroup();
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler("EchoServer Handler"))).childHandler((ChannelHandler)new EchoServerInitializer(secure, error)).bind(port).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            hasStarted.set((Object)"STARTED");
                        } else {
                            hasStarted.setException(future.cause());
                            EchoServer.this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }
        }, "MockServer EchoServer Thread").start();
        try {
            hasStarted.get();
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (Exception e) {
            logger.error("Exception while waiting for proxy to complete starting up", (Throwable)e);
        }
    }

    public void stop() {
        this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
    }

    public static enum Error {
        CLOSE_CONNECTION,
        LARGER_CONTENT_LENGTH,
        SMALLER_CONTENT_LENGTH,
        RANDOM_BYTES_RESPONSE;

    }
}

