/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.hubservices.core.v2;
using be.fgov.ehealth.standards.kmehr.id.v1;
using NUnit.Framework;
using be.ehealth.technicalconnector.utils;

namespace be.ehealth.businessconnector.wsconsent.service
{
	/// <summary>
	/// Description of TestUtils.
	/// </summary>
	public class TestUtils
	{
	    /**
	     * private constructor : only static methods on this class should be used.
	     */
	    private TestUtils() {
	    }
	
	    /**
	     * Method which creates a dummy patient.
	     * 
	     * @return
	     */
	    public static PatientIdType createDummyPatient() {
	
	        PatientIdType patient = new PatientIdType();
	        // Ask Matching
	
	        patient.setName("dummyPatient");
	        patient.setFamilyname("dummyFamilyName");
	        patient.setFirstname("john");
	
	        be.fgov.ehealth.standards.kmehr.id.v1.ObjectFactory objectFactoryIdPatient = new be.fgov.ehealth.standards.kmehr.id.v1.ObjectFactory();
	        IDPATIENT idPatient = objectFactoryIdPatient.createIDPATIENT();
	        idPatient.setSV("1.0");
	        idPatient.setS(IDPATIENTschemes.INSS);
	        idPatient.setValue("123456789");
	
	
	        IDPATIENT idPatient2 = objectFactoryIdPatient.createIDPATIENT();
	        idPatient2.setSV("1.0");
	        idPatient2.setS(IDPATIENTschemes.EID_CARDNO);
	        idPatient2.setValue("123456789");
	
	        patient.getIds().add(idPatient);
	        patient.getIds().add(idPatient2);
	
	        return patient;
	    }
	
	    public static void assertXmlSimular(String fileLocation, String actual) {
	            String expected = be.ehealth.technicalconnector.utils.ConnectorIOUtils.convertStreamToString(be.ehealth.technicalconnector.utils.ConnectorIOUtils.getResourceAsStream(fileLocation));
		        String xmlString = convertJaxbObjectToString(actual);
		
		        be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(expected, xmlString);
	    }	

	    /**
	     * @param consentRequest
	     * @return
	     */
	    private static String convertJaxbObjectToString(String	consentRequest) {
	    	MarshallerHelper marshaller = new MarshallerHelper(typeof(java.lang.String), typeof(java.lang.String));
	        String xmlString = marshaller.toString(consentRequest);
	        return xmlString;
    	}		
	}
}
