/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import be.ehealth.technicalconnector.generic.session.GenericService;
import be.ehealth.technicalconnector.generic.session.GenericSessionServiceFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * Generic Sender Integration Test This test shows how to use the generic sender.
 * 
 * @author EHP
 */
public class GenericSenderIntegrationTest {


    private static final String ENDPOINT = "https://services-acpt.ehealth.fgov.be/ehBoxConsultation/v3";

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession()
                                                .build();

    @Test
    public void testGenericSenderXMLWithURL() throws Exception {
        GenericService service = GenericSessionServiceFactory.getGenericService();
        String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v3'><Source>INBOX</Source></ns2:GetMessagesListRequest>";

        String response = service.sendXML(payload, new URL(ENDPOINT));
        Assert.assertNotNull(response);
    }


    @Test
    public void testGenericSenderXML() throws Exception {
        GenericService service = GenericSessionServiceFactory.getGenericService();
        String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v3'><Source>INBOX</Source></ns2:GetMessagesListRequest>";

        String response = service.sendXML(payload, ENDPOINT);
        Assert.assertNotNull(response);
    }


    @Test
    public void testGenericSenderDocumentWithUrl() throws Exception {
        GenericService service = GenericSessionServiceFactory.getGenericService();
        String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v3'><Source>INBOX</Source></ns2:GetMessagesListRequest>";
        Node response = service.sendDocument(parse(payload), new URL(ENDPOINT));
        Assert.assertNotNull(response);
    }


    private Document parse(String input) throws Exception {
        InputStream sbis = new ByteArrayInputStream(input.getBytes("UTF-8"));
        DocumentBuilderFactory b = DocumentBuilderFactory.newInstance();
        b.setNamespaceAware(true);
        javax.xml.parsers.DocumentBuilder db = b.newDocumentBuilder();
        return db.parse(sbis);
    }


    @Test
    public void testGenericSenderDocument() throws Exception {
        GenericService service = GenericSessionServiceFactory.getGenericService();
        String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v3'><Source>INBOX</Source></ns2:GetMessagesListRequest>";

        Node response = service.sendDocument(parse(payload), ENDPOINT);
        Assert.assertNotNull(response);
    }

}
