package be.ehealth.technicalconnector.handler;

import static be.ehealth.technicalconnector.handler.LoggingHandler.MESSAGE_ENDPOINT_ADDRESS;
import static be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation.CacheType.ENDPOINT_FIRST;
import static be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation.ExpiryType.NONE;
import static be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation.KeyTransformType.XSLT;

import java.lang.reflect.Method;
import java.util.Arrays;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.ws.impl.SOAPMessageContextImpl;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointDistributor;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;

public class CacheFeederHandlerTest {

    public static final String ENDPOINT = "http://localhost:7777";

    public static final String SERVICE = "mockservice";

    @BeforeClass
    public static void before() {
        LoggingUtils.bootstrap();
    }

    @Test
    public void test() throws Exception {

        EndPointInformation info = new EndPointInformation();

        info.register(SERVICE, ENDPOINT, ENDPOINT, Arrays.asList(ENDPOINT), new CacheInformation("", ENDPOINT_FIRST, XSLT, "/xslt/mock.service.xslt", NONE, null));
        EndpointDistributor dist = EndpointDistributor.getInstance();
        Method update = dist.getClass()
                            .getDeclaredMethod("update", EndPointInformation.class);
        update.setAccessible(true);
        update.invoke(dist, info);

        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage soapMessage = mf.createMessage();
        soapMessage.getSOAPBody()
                   .addChildElement(new QName("dch", "RelatesTo", "dch"));
        SOAPMessageContext context = new SOAPMessageContextImpl(soapMessage);

        context.put(MessageContext.MESSAGE_OUTBOUND_PROPERTY, Boolean.TRUE);
        context.put(MESSAGE_ENDPOINT_ADDRESS, ENDPOINT);

        CacheFeederHandler handler = new CacheFeederHandler();
        handler.handleMessage(context);

        context.put(MessageContext.MESSAGE_OUTBOUND_PROPERTY, Boolean.FALSE);
        handler.handleMessage(context);

        // ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        // ObjectName objectName = new ObjectName("javax.cache:type=CacheStatistics," +
        // "CacheManager=" + CacheFeederHandler.getCacheManager().getURI().toString().replaceAll(":", ".") +
        // ",Cache=" + SERVICE);

        // Assert.assertEquals(1L, mBeanServers.get(0).getAttribute(objectName, "CachePuts"));


    }


}
