/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.adapter;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;


/**
 * Unit test for {@link XmlDateNoTzAdapter}
 *
 * @author Olivier Chapuis (eh077))
 */
public class XmlDateNoTzAdapterTest {

    @Test
    public void testDateCreatedWithoutTimezone() throws Exception {
        XmlDateNoTzAdapter xmlDateNoTzAdapter = new XmlDateNoTzAdapter();
        DateTime dateWithTimeZone = xmlDateNoTzAdapter.unmarshal("2013-01-01+01:00");
        Assert.assertEquals("2013-01-01", xmlDateNoTzAdapter.marshal(dateWithTimeZone));
    }
}
