/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.hub.security;

import be.ehealth.businessconnector.hub.util.RequestTypeBuilder;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.fgov.ehealth.hubservices.core.v1.RequestType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import javax.xml.bind.JAXB;
import java.util.List;

import static org.junit.Assert.fail;


/**
 * Integration test for {@link HubRequestWithEncryption}
 * 
 * @author EHP
 * 
 */
public class HubRequestWithEncryptionIntegrationTest {

    @Rule
    public SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();

    @Test
    public void testRequestTypeBuilderWithIDEncryptionKey() throws Exception {
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.usedefaultproperties", "false");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.hcpartylist", "identifier");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.id.inss.value", "${careprovider.inss}");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.id.inss.sv", "1.0");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.id.idhcparty.value", "${careprovider.nihii}");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.id.idhcparty.sv", "1.0");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.cd.cdhcparty.value", "${main.kmehr.quality}");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.cd.cdhcparty.sv", "1.1");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.firstname", "${careprovider.firstname}");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.lastname", "${careprovider.lastname}");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.id.idencryptionkey", "true");
        ConfigFactory.getConfigValidator().getConfig().setProperty("kmehr.intrahub.identifier.id.idencryptionkey.sv", "1.0");
        Assert.assertTrue("ID_ENCRYPTION_KEY should be added", hasIdEncryptionKey(buildRequest()));
    }

    @Test
    public void testRequestTypeBuilderWithoutIDEncryptionKey() throws Exception {
        Assert.assertFalse("ID_ENCRYPTION_KEY should not be added", hasIdEncryptionKey(buildRequest()));
    }

    /* Private methods */

    private boolean hasIdEncryptionKey(RequestType requestType) {
        List<HcpartyType> partiesList = requestType.getAuthor().getHcparties();
        boolean containsEncryption = false;
        boolean containsEncryptionKey = false;
        for (HcpartyType hcpartyType : partiesList) {
            if (hcpartyType.getFirstname() != null) {
                for (IDHCPARTY hcparty : hcpartyType.getIds()) {
                    if (hcparty.getS().compareTo(IDHCPARTYschemes.ID_ENCRYPTION_ACTOR) == 0) {
                        containsEncryption = true;
                    } else {
                        if (hcparty.getS().compareTo(IDHCPARTYschemes.ID_ENCRYPTION_KEY) == 0) {
                            containsEncryptionKey = true;
                        }
                    }
                }
            }
        }

        Assert.assertTrue(containsEncryption);

        return containsEncryptionKey;
    }

    private RequestType buildRequest() throws Exception {
        RequestType requestType = RequestTypeBuilder.init().addAuthorWithEncryptionInformation().build();
        JAXB.marshal(requestType, System.out);
        return requestType;
    }

}
