/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.kmehrcommons.validator.impl;

import java.io.InputStream;

import javax.xml.bind.JAXB;

import be.ehealth.business.kmehrcommons.validator.impl.KmehrValidatorImpl;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.business.kmehrcommons.validator.KmehrValidator;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;


/**
 * @author eh076
 *
 */
public class KmehrValidatorImplTest {


    /**
     * @throws Exception
     */
    @Test
    public void testValidateKmehrMessage() throws Exception {
        Kmehrmessage message = JAXB.unmarshal(KmehrValidatorImplTest.class.getResourceAsStream("/kmehrcommons/examples/persphysician-chapter4-consultation-request-with-ssin-kmehr.xml"), Kmehrmessage.class);
        KmehrValidator validator = new KmehrValidatorImpl();
        validator.validateKmehrMessage(message);
    }

    @Test
    public void testLoadXSDFromClassPath() throws Exception {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(KmehrValidatorImpl.KMEHR_LOCATION);
        Assert.assertNotNull(inputStream);
    }


}
