/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.kmehrcommons.builders;

import be.ehealth.business.kmehrcommons.builders.Cd;
import org.junit.Assert;
import org.junit.Test;

import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;


/**
 * @author EH076
 *
 */
public class CdTest {

    @Test
    public void test() {
        CDHCPARTY cd = new Cd().value("value").l("l").sl("sl").s(CDHCPARTYschemes.LOCAL).sv("1.0").dn("dn").build();
        org.junit.Assert.assertEquals("dn", cd.getDN());
        org.junit.Assert.assertEquals("l", cd.getL());
        org.junit.Assert.assertEquals(CDHCPARTYschemes.LOCAL, cd.getS());
        org.junit.Assert.assertEquals("sl", cd.getSL());
        org.junit.Assert.assertEquals("1.0", cd.getSV());
        org.junit.Assert.assertEquals("value", cd.getValue());

    }

    @Test(expected = IllegalArgumentException.class)
    public void testValidation() {
        new Cd().build();
    }

    @Test
    public void testValidationMinimalInfo() {
        CDHCPARTY cd = new Cd().s(CDHCPARTYschemes.CD_HCPARTY).sv("sv").build();
        Assert.assertNotNull(cd);
    }

    @Test
    public void testValidationLocalCode() {
        try {
            new Cd().s(CDHCPARTYschemes.LOCAL).sv("sv").build();
            Assert.fail("should fail because sl is required for local code");
        } catch (IllegalArgumentException e) {
            Assert.assertEquals("when s==local, sl may not be null", e.getMessage());
        }
    }

}
